/*
 * Decompiled with CFR 0.152.
 */
package com.helger.cache.clazz;

import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.ETriState;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import jakarta.annotation.Nonnull;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@NotThreadSafe
public class AnnotationUsageCache {
    private final Class<? extends Annotation> m_aAnnotationClass;
    private final ICommonsMap<String, ETriState> m_aMap = new CommonsHashMap();

    public AnnotationUsageCache(@Nonnull Class<? extends Annotation> clazz) {
        RetentionPolicy retentionPolicy;
        ValueEnforcer.notNull(clazz, (String)"AnnotationClass");
        Retention retention = clazz.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy2 = retentionPolicy = retention == null ? RetentionPolicy.CLASS : retention.value();
        if (retentionPolicy != RetentionPolicy.RUNTIME) {
            throw new IllegalArgumentException("RetentionPolicy must be of type RUNTIME to be used within this cache. The current value ist " + String.valueOf((Object)retentionPolicy));
        }
        this.m_aAnnotationClass = clazz;
    }

    @Nonnull
    public final Class<? extends Annotation> getAnnotationClass() {
        return this.m_aAnnotationClass;
    }

    public boolean hasAnnotation(@Nonnull Object object) {
        ValueEnforcer.notNull((Object)object, (String)"Object");
        return this.hasAnnotation(object.getClass());
    }

    public boolean hasAnnotation(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        String string = clazz.getName();
        ETriState eTriState = (ETriState)this.m_aMap.get((Object)string);
        if (eTriState == null) {
            eTriState = ETriState.valueOf((clazz.getAnnotation(this.m_aAnnotationClass) != null ? 1 : 0) != 0);
            this.m_aMap.put((Object)string, (Object)eTriState);
        }
        return eTriState.isTrue();
    }

    public void setAnnotation(@Nonnull Class<?> clazz, boolean bl) {
        ValueEnforcer.notNull(clazz, (String)"Class");
        String string = clazz.getName();
        this.m_aMap.put((Object)string, (Object)ETriState.valueOf((boolean)bl));
    }

    public void clearCache() {
        this.m_aMap.clear();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("AnnotationClass", this.m_aAnnotationClass).append("Map", this.m_aMap).getToString();
    }

    private /* synthetic */ ETriState lambda$hasAnnotation$0(Class clazz, String string) {
        return ETriState.valueOf((clazz.getAnnotation(this.m_aAnnotationClass) != null ? 1 : 0) != 0);
    }
}

