/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.zone;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import jakarta.annotation.Nonnull;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class PDTZoneID {
    private static final ICommonsList<PDTZoneID> ZONES = new CommonsArrayList();
    private final String m_sZoneID;
    private final ZoneId m_aZoneID;

    protected PDTZoneID(@Nonnull @Nonempty String string, @Nonnull ZoneId zoneId) {
        this.m_sZoneID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ZoneIDString");
        this.m_aZoneID = (ZoneId)ValueEnforcer.notNull((Object)zoneId, (String)"ZoneID");
    }

    @Nonnull
    @Nonempty
    public String getZoneIDString() {
        return this.m_sZoneID;
    }

    @Nonnull
    public ZoneId getZoneID() {
        return this.m_aZoneID;
    }

    @Nonnull
    public static PDTZoneID of(@Nonnull String string) {
        return new PDTZoneID(string, ZoneId.of(string));
    }

    @Nonnull
    public static PDTZoneID ofHours(@Nonnull String string, int n) {
        return new PDTZoneID(string, ZoneOffset.ofHours(n));
    }

    @Nonnull
    public static ICommonsIterable<PDTZoneID> getDefaultZoneIDs() {
        return ZONES;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<PDTZoneID> getAllDefaultZoneIDs() {
        return (ICommonsList)ZONES.getClone();
    }

    static {
        ZONES.add((Object)PDTZoneID.of("UTC"));
        ZONES.add((Object)PDTZoneID.of("GMT"));
        ZONES.add((Object)PDTZoneID.ofHours("EST", -5));
        ZONES.add((Object)PDTZoneID.ofHours("EDT", -4));
        ZONES.add((Object)PDTZoneID.ofHours("CST", -6));
        ZONES.add((Object)PDTZoneID.ofHours("CDT", -5));
        ZONES.add((Object)PDTZoneID.ofHours("MST", -7));
        ZONES.add((Object)PDTZoneID.ofHours("MDT", -6));
        ZONES.add((Object)PDTZoneID.ofHours("PST", -8));
        ZONES.add((Object)PDTZoneID.ofHours("PDT", -7));
        ZONES.add((Object)PDTZoneID.of("UT"));
        ZONES.add((Object)PDTZoneID.ofHours("A", -1));
        ZONES.add((Object)PDTZoneID.ofHours("B", -2));
        ZONES.add((Object)PDTZoneID.ofHours("C", -3));
        ZONES.add((Object)PDTZoneID.ofHours("D", -4));
        ZONES.add((Object)PDTZoneID.ofHours("E", -5));
        ZONES.add((Object)PDTZoneID.ofHours("F", -6));
        ZONES.add((Object)PDTZoneID.ofHours("G", -7));
        ZONES.add((Object)PDTZoneID.ofHours("H", -8));
        ZONES.add((Object)PDTZoneID.ofHours("I", -9));
        ZONES.add((Object)PDTZoneID.ofHours("K", -10));
        ZONES.add((Object)PDTZoneID.ofHours("L", -11));
        ZONES.add((Object)PDTZoneID.ofHours("M", -12));
        ZONES.add((Object)PDTZoneID.ofHours("N", 1));
        ZONES.add((Object)PDTZoneID.ofHours("O", 2));
        ZONES.add((Object)PDTZoneID.ofHours("P", 3));
        ZONES.add((Object)PDTZoneID.ofHours("Q", 4));
        ZONES.add((Object)PDTZoneID.ofHours("R", 5));
        ZONES.add((Object)PDTZoneID.ofHours("S", 6));
        ZONES.add((Object)PDTZoneID.ofHours("T", 7));
        ZONES.add((Object)PDTZoneID.ofHours("U", 8));
        ZONES.add((Object)PDTZoneID.ofHours("V", 9));
        ZONES.add((Object)PDTZoneID.ofHours("W", 10));
        ZONES.add((Object)PDTZoneID.ofHours("X", 11));
        ZONES.add((Object)PDTZoneID.ofHours("Y", 12));
        ZONES.add((Object)PDTZoneID.of("Z"));
    }
}

