/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currencyvalue;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.numeric.BigHelper;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.IHasCurrency;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;

@MustImplementEqualsAndHashcode
public interface ICurrencyValue
extends IHasCurrency {
    @Nonnull
    public BigDecimal getValue();

    default public boolean isLT0() {
        return BigHelper.isLT0((BigDecimal)this.getValue());
    }

    default public boolean isLE0() {
        return BigHelper.isLE0((BigDecimal)this.getValue());
    }

    default public boolean isEQ0() {
        return BigHelper.isEQ0((BigDecimal)this.getValue());
    }

    default public boolean isNE0() {
        return BigHelper.isNE0((BigDecimal)this.getValue());
    }

    default public boolean isGT0() {
        return BigHelper.isGT0((BigDecimal)this.getValue());
    }

    default public boolean isGE0() {
        return BigHelper.isGE0((BigDecimal)this.getValue());
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getAdded(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getAdded(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getAdded(BigHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getSubtracted(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getSubtracted(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getSubtracted(BigHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getMultiplied(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getMultiplied(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getMultiplied(BigHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getDivided(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getDivided(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getDivided(BigHelper.toBigDecimal((long)l));
    }

    @Nonnull
    default public String getCurrencyFormatted() {
        return CurrencyHelper.getCurrencyFormatted(this.getCurrency(), this.getValue());
    }

    @Nonnull
    default public String getCurrencyFormatted(@Nonnegative int n) {
        return CurrencyHelper.getCurrencyFormatted(this.getCurrency(), this.getValue(), n);
    }

    @Nonnull
    default public String getValueFormatted() {
        return CurrencyHelper.getValueFormatted(this.getCurrency(), this.getValue());
    }

    @Nonnull
    default public String getValueFormatted(@Nonnegative int n) {
        return CurrencyHelper.getValueFormatted(this.getCurrency(), this.getValue(), n);
    }
}

