/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.string.StringHelper;
import com.helger.cache.regex.RegExHelper;
import com.helger.masterdata.telephone.ITelephoneNumber;
import jakarta.annotation.Nullable;

@Immutable
public final class TelephoneHelper {
    private TelephoneHelper() {
    }

    @Nullable
    @CheckReturnValue
    public static String getTelephoneString(@Nullable ITelephoneNumber iTelephoneNumber) {
        if (iTelephoneNumber == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringHelper.isNotEmpty((String)iTelephoneNumber.getCountryCode()) && StringHelper.isNotEmpty((String)iTelephoneNumber.getAreaCode())) {
            if (!StringHelper.startsWith((CharSequence)iTelephoneNumber.getCountryCode(), (char)'+')) {
                stringBuilder.append('+');
            }
            stringBuilder.append(iTelephoneNumber.getCountryCode()).append('/');
            if (StringHelper.startsWith((CharSequence)iTelephoneNumber.getAreaCode(), (char)'0')) {
                stringBuilder.append(iTelephoneNumber.getAreaCode().substring(1));
            } else {
                stringBuilder.append(iTelephoneNumber.getAreaCode());
            }
        } else if (iTelephoneNumber.getAreaCode() != null) {
            stringBuilder.append(iTelephoneNumber.getAreaCode());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('/');
        }
        if (iTelephoneNumber.getLine() != null) {
            stringBuilder.append(iTelephoneNumber.getLine());
        }
        if (StringHelper.isNotEmpty((String)iTelephoneNumber.getDirectDial())) {
            stringBuilder.append('-').append(iTelephoneNumber.getDirectDial());
        }
        return stringBuilder.toString();
    }

    @Nullable
    @CheckReturnValue
    public static String getCleanedLine(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2)) {
            string2 = RegExHelper.stringReplacePattern((String)"begin_of_the_skype_highlighting.+end_of_the_skype_highlighting", (String)string2, (String)"");
        }
        return string2;
    }
}

