/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.reporting.api;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.MustImplementEqualsAndHashcode;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.log.ConditionalLogger;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.peppol.reporting.api.EReportingDirection;
import com.helger.peppol.reporting.api.PeppolReportingHelper;
import com.helger.peppol.smp.ESMPTransportProfile;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
@MustImplementEqualsAndHashcode
public final class PeppolReportingItem {
    public static final int MAX_LEN_C2_ID = 64;
    public static final int MAX_LEN_C3_ID = 64;
    public static final int MAX_LEN_DOCTYPE_SCHEME = 64;
    public static final int MAX_LEN_DOCTYPE_VALUE = 500;
    public static final int MAX_LEN_PROCESS_SCHEME = 64;
    public static final int MAX_LEN_PROCESS_VALUE = 200;
    public static final int MAX_LEN_TRANSPORT_PROTOCOL = 64;
    public static final int LEN_COUNTRY_CODE = 2;
    public static final int MAX_LEN_C1_COUNTRY_CODE = 2;
    public static final int MAX_LEN_C4_COUNTRY_CODE = 2;
    public static final int MAX_LEN_END_USER_ID = 256;
    private final OffsetDateTime m_aExchangeDTUTC;
    private final EReportingDirection m_eDirection;
    private final String m_sC2ID;
    private final String m_sC3ID;
    private final String m_sDocTypeIDScheme;
    private final String m_sDocTypeIDValue;
    private final String m_sProcessIDScheme;
    private final String m_sProcessIDValue;
    private final String m_sTransportProtocol;
    private final String m_sC1CountryCode;
    private final String m_sC4CountryCode;
    private final String m_sEndUserID;

    public PeppolReportingItem(@NonNull OffsetDateTime offsetDateTime, @NonNull EReportingDirection eReportingDirection, @Nonempty @NonNull String string, @Nonempty @NonNull String string2, @Nonempty @NonNull String string3, @Nonempty @NonNull String string4, @Nonempty @NonNull String string5, @Nonempty @NonNull String string6, @Nonempty @NonNull String string7, @Nonempty @NonNull String string8, @Nullable String string9, @Nonempty @NonNull String string10) {
        ValueEnforcer.notNull((Object)offsetDateTime, (String)"ExchangeDT");
        ValueEnforcer.notNull((Object)((Object)eReportingDirection), (String)"Direction");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"C2ID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"C3ID");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"DocTypeIDScheme");
        ValueEnforcer.notEmpty((CharSequence)string4, (String)"DocTypeIDValue");
        ValueEnforcer.notEmpty((CharSequence)string5, (String)"ProcessIDScheme");
        ValueEnforcer.notEmpty((CharSequence)string6, (String)"ProcessIDValue");
        ValueEnforcer.notEmpty((CharSequence)string7, (String)"TransportProtocol");
        ValueEnforcer.notEmpty((CharSequence)string8, (String)"C1CountryCode");
        if (eReportingDirection.isReceiving()) {
            ValueEnforcer.notEmpty((CharSequence)string9, (String)"C4CountryCode");
        }
        ValueEnforcer.notEmpty((CharSequence)string10, (String)"EndUserID");
        this.m_aExchangeDTUTC = offsetDateTime.atZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime().truncatedTo(ChronoUnit.MILLIS);
        this.m_eDirection = eReportingDirection;
        this.m_sC2ID = string;
        this.m_sC3ID = string2;
        this.m_sDocTypeIDScheme = string3;
        this.m_sDocTypeIDValue = string4;
        this.m_sProcessIDScheme = string5;
        this.m_sProcessIDValue = string6;
        this.m_sTransportProtocol = string7;
        this.m_sC1CountryCode = string8;
        this.m_sC4CountryCode = string9;
        this.m_sEndUserID = string10;
    }

    public @NonNull OffsetDateTime getExchangeDTUTC() {
        return this.m_aExchangeDTUTC;
    }

    public @NonNull EReportingDirection getDirection() {
        return this.m_eDirection;
    }

    public boolean isSending() {
        return this.m_eDirection.isSending();
    }

    public boolean isReceiving() {
        return this.m_eDirection.isReceiving();
    }

    @Nonempty
    public @NonNull String getC2ID() {
        return this.m_sC2ID;
    }

    @Nonempty
    public @NonNull String getC3ID() {
        return this.m_sC3ID;
    }

    @Nonempty
    public @NonNull String getOtherServiceProviderID() {
        return this.m_eDirection.isSending() ? this.m_sC3ID : this.m_sC2ID;
    }

    @Nonempty
    public @NonNull String getDocTypeIDScheme() {
        return this.m_sDocTypeIDScheme;
    }

    @Nonempty
    public @NonNull String getDocTypeIDValue() {
        return this.m_sDocTypeIDValue;
    }

    @Nonempty
    public @NonNull String getProcessIDScheme() {
        return this.m_sProcessIDScheme;
    }

    @Nonempty
    public @NonNull String getProcessIDValue() {
        return this.m_sProcessIDValue;
    }

    @Nonempty
    public @NonNull String getC1CountryCode() {
        return this.m_sC1CountryCode;
    }

    public @Nullable String getC4CountryCode() {
        return this.m_sC4CountryCode;
    }

    public boolean hasC4CountryCode() {
        return this.m_sC4CountryCode != null;
    }

    @Nonempty
    public @NonNull String getTransportProtocol() {
        return this.m_sTransportProtocol;
    }

    @Nonempty
    public @NonNull String getEndUserCountryCode() {
        return this.m_eDirection.isSending() ? this.m_sC1CountryCode : this.m_sC4CountryCode;
    }

    @Nonempty
    public @NonNull String getEndUserID() {
        return this.m_sEndUserID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PeppolReportingItem peppolReportingItem = (PeppolReportingItem)object;
        return this.m_aExchangeDTUTC.equals(peppolReportingItem.m_aExchangeDTUTC) && this.m_eDirection.equals((Object)peppolReportingItem.m_eDirection) && this.m_sC2ID.equals(peppolReportingItem.m_sC2ID) && this.m_sC3ID.equals(peppolReportingItem.m_sC3ID) && this.m_sDocTypeIDScheme.equals(peppolReportingItem.m_sDocTypeIDScheme) && this.m_sDocTypeIDValue.equals(peppolReportingItem.m_sDocTypeIDValue) && this.m_sProcessIDScheme.equals(peppolReportingItem.m_sProcessIDScheme) && this.m_sProcessIDValue.equals(peppolReportingItem.m_sProcessIDValue) && this.m_sTransportProtocol.equals(peppolReportingItem.m_sTransportProtocol) && this.m_sC1CountryCode.equals(peppolReportingItem.m_sC1CountryCode) && EqualsHelper.equals((Object)this.m_sC4CountryCode, (Object)peppolReportingItem.m_sC4CountryCode) && this.m_sEndUserID.equals(peppolReportingItem.m_sEndUserID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aExchangeDTUTC).append((Object)this.m_eDirection).append((Object)this.m_sC2ID).append((Object)this.m_sC3ID).append((Object)this.m_sDocTypeIDScheme).append((Object)this.m_sDocTypeIDValue).append((Object)this.m_sProcessIDScheme).append((Object)this.m_sProcessIDValue).append((Object)this.m_sTransportProtocol).append((Object)this.m_sC1CountryCode).append((Object)this.m_sC4CountryCode).append((Object)this.m_sEndUserID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("ExchangeDTUTC", (Object)this.m_aExchangeDTUTC).append("Direction", (Enum)this.m_eDirection).append("C2ID", (Object)this.m_sC2ID).append("C3ID", (Object)this.m_sC3ID).append("DocTypeIDScheme", (Object)this.m_sDocTypeIDScheme).append("DocTypeIDValue", (Object)this.m_sDocTypeIDValue).append("ProcessIDScheme", (Object)this.m_sProcessIDScheme).append("ProcessIDValue", (Object)this.m_sProcessIDValue).append("TransportProtocol", (Object)this.m_sTransportProtocol).append("C1CountryCode", (Object)this.m_sC1CountryCode).append("C4CountryCode", (Object)this.m_sC4CountryCode).append("EndUserID", (Object)this.m_sEndUserID).getToString();
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IBuilder<PeppolReportingItem> {
        private static final Logger LOGGER = LoggerFactory.getLogger(Builder.class);
        private OffsetDateTime m_aExchangeDT;
        private EReportingDirection m_eDirection;
        private String m_sC2ID;
        private String m_sC3ID;
        private String m_sDocTypeIDScheme;
        private String m_sDocTypeIDValue;
        private String m_sProcessIDScheme;
        private String m_sProcessIDValue;
        private String m_sTransportProtocol;
        private String m_sC1CountryCode;
        private String m_sC4CountryCode;
        private String m_sEndUserID;

        public @NonNull Builder exchangeDateTime(@Nullable OffsetDateTime offsetDateTime) {
            this.m_aExchangeDT = offsetDateTime;
            return this;
        }

        public @NonNull Builder exchangeDateTime(@Nullable ZonedDateTime zonedDateTime) {
            return this.exchangeDateTime(zonedDateTime == null ? null : zonedDateTime.toOffsetDateTime());
        }

        public @NonNull Builder exchangeDateTimeInUTC(@Nullable LocalDateTime localDateTime) {
            return this.exchangeDateTime(localDateTime == null ? null : localDateTime.atOffset(ZoneOffset.UTC));
        }

        public @NonNull Builder direction(@Nullable EReportingDirection eReportingDirection) {
            this.m_eDirection = eReportingDirection;
            return this;
        }

        public @NonNull Builder directionSending() {
            return this.direction(EReportingDirection.SENDING);
        }

        public @NonNull Builder directionReceiving() {
            return this.direction(EReportingDirection.RECEIVING);
        }

        public @NonNull Builder c2ID(@Nullable String string) {
            this.m_sC2ID = string;
            return this;
        }

        public @NonNull Builder c3ID(@Nullable String string) {
            this.m_sC3ID = string;
            return this;
        }

        public @NonNull Builder docTypeIDScheme(@Nullable String string) {
            this.m_sDocTypeIDScheme = string;
            return this;
        }

        public @NonNull Builder docTypeIDValue(@Nullable String string) {
            this.m_sDocTypeIDValue = string;
            return this;
        }

        public @NonNull Builder docTypeID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
            return this.docTypeIDScheme(iDocumentTypeIdentifier == null ? null : iDocumentTypeIdentifier.getScheme()).docTypeIDValue(iDocumentTypeIdentifier == null ? null : iDocumentTypeIdentifier.getValue());
        }

        public @NonNull Builder processIDScheme(@Nullable String string) {
            this.m_sProcessIDScheme = string;
            return this;
        }

        public @NonNull Builder processIDValue(@Nullable String string) {
            this.m_sProcessIDValue = string;
            return this;
        }

        public @NonNull Builder processID(@Nullable IProcessIdentifier iProcessIdentifier) {
            return this.processIDScheme(iProcessIdentifier == null ? null : iProcessIdentifier.getScheme()).processIDValue(iProcessIdentifier == null ? null : iProcessIdentifier.getValue());
        }

        public @NonNull Builder transportProtocol(@Nullable String string) {
            this.m_sTransportProtocol = string;
            return this;
        }

        public @NonNull Builder transportProtocol(@Nullable ISMPTransportProfile iSMPTransportProfile) {
            return this.transportProtocol(iSMPTransportProfile == null ? null : iSMPTransportProfile.getID());
        }

        public @NonNull Builder transportProtocolPeppolAS4v2() {
            return this.transportProtocol((ISMPTransportProfile)ESMPTransportProfile.TRANSPORT_PROFILE_PEPPOL_AS4_V2);
        }

        public @NonNull Builder c1CountryCode(@Nullable String string) {
            this.m_sC1CountryCode = string;
            return this;
        }

        public @NonNull Builder c4CountryCode(@Nullable String string) {
            this.m_sC4CountryCode = string;
            return this;
        }

        public @NonNull Builder endUserID(@Nullable String string) {
            this.m_sEndUserID = string;
            return this;
        }

        public boolean isComplete(boolean bl) {
            ConditionalLogger conditionalLogger = new ConditionalLogger(LOGGER, bl);
            if (this.m_aExchangeDT == null) {
                conditionalLogger.warn("ExchangeDateTime is missing");
                return false;
            }
            if (this.m_eDirection == null) {
                conditionalLogger.warn("Direction is missing");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sC2ID)) {
                conditionalLogger.warn("C2 ID is missing");
                return false;
            }
            if (this.m_sC2ID.length() > 64) {
                conditionalLogger.warn(() -> "C2 ID exceeds the maximium length of 64");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sC3ID)) {
                conditionalLogger.warn("C3 ID is missing");
                return false;
            }
            if (this.m_sC3ID.length() > 64) {
                conditionalLogger.warn(() -> "C3 ID exceeds the maximium length of 64");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sDocTypeIDScheme)) {
                conditionalLogger.warn("Document Type ID Scheme is missing");
                return false;
            }
            if (this.m_sDocTypeIDScheme.length() > 64) {
                conditionalLogger.warn(() -> "Document Type ID Scheme exceeds the maximium length of 64");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sDocTypeIDValue)) {
                conditionalLogger.warn("Document Type ID Value is missing");
                return false;
            }
            if (this.m_sDocTypeIDValue.length() > 500) {
                conditionalLogger.warn(() -> "Document Type ID Value exceeds the maximium length of 500");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sProcessIDScheme)) {
                conditionalLogger.warn("Process ID Scheme is missing");
                return false;
            }
            if (this.m_sProcessIDScheme.length() > 64) {
                conditionalLogger.warn(() -> "Process ID Scheme exceeds the maximium length of 64");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sProcessIDValue)) {
                conditionalLogger.warn("Process ID Value is missing");
                return false;
            }
            if (this.m_sProcessIDValue.length() > 200) {
                conditionalLogger.warn(() -> "Process ID Value exceeds the maximium length of 200");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sTransportProtocol)) {
                conditionalLogger.warn("Transport Protocol is missing");
                return false;
            }
            if (this.m_sTransportProtocol.length() > 64) {
                conditionalLogger.warn(() -> "Transport Protocol exceeds the maximium length of 64");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sC1CountryCode)) {
                conditionalLogger.warn("C1 Country Code is missing");
                return false;
            }
            if (!PeppolReportingHelper.isValidCountryCode(this.m_sC1CountryCode)) {
                conditionalLogger.error("C1 Country Code has an invalid layout");
                return false;
            }
            if (StringHelper.isEmpty((String)this.m_sC4CountryCode)) {
                if (this.m_eDirection.isReceiving()) {
                    conditionalLogger.warn("C4 Country Code is missing");
                    return false;
                }
            } else {
                if (this.m_eDirection.isSending()) {
                    conditionalLogger.warn("C4 Country Code cannot be provided for outgoing/sent messages");
                    return false;
                }
                if (!PeppolReportingHelper.isValidCountryCode(this.m_sC4CountryCode)) {
                    conditionalLogger.error("C4 Country Code has an invalid layout");
                    return false;
                }
            }
            if (StringHelper.isEmpty((String)this.m_sEndUserID)) {
                conditionalLogger.warn("End User ID is missing");
                return false;
            }
            if (this.m_sEndUserID.length() > 256) {
                conditionalLogger.warn(() -> "End User ID exceeds the maximium length of 256");
                return false;
            }
            return true;
        }

        public @NonNull PeppolReportingItem build() {
            if (!this.isComplete(true)) {
                throw new IllegalStateException("The builder was not filled completely");
            }
            return new PeppolReportingItem(this.m_aExchangeDT, this.m_eDirection, this.m_sC2ID, this.m_sC3ID, this.m_sDocTypeIDScheme, this.m_sDocTypeIDValue, this.m_sProcessIDScheme, this.m_sProcessIDValue, this.m_sTransportProtocol, this.m_sC1CountryCode, this.m_sC4CountryCode, this.m_sEndUserID);
        }
    }
}

