/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.attachment;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.builder.IBuilder;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.mime.CMimeType;
import com.helger.mime.IMimeType;
import com.helger.phase4.attachment.EAS4CompressionMode;
import com.helger.phase4.model.message.MessageHelperMethods;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.charset.Charset;

@Immutable
public class AS4OutgoingAttachment {
    private final ByteArrayWrapper m_aDataBytes;
    private final File m_aDataFile;
    private final String m_sContentID;
    private final String m_sFilename;
    private final IMimeType m_aMimeType;
    private final EAS4CompressionMode m_eCompressionMode;
    private final Charset m_aCharset;
    private final ICommonsOrderedMap<String, String> m_aCustomProperties;

    protected AS4OutgoingAttachment(@Nullable ByteArrayWrapper byteArrayWrapper, @Nullable File file, @Nullable String string, @Nullable String string2, @Nonnull IMimeType iMimeType, @Nullable EAS4CompressionMode eAS4CompressionMode, @Nullable Charset charset, @Nullable ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
        ValueEnforcer.isTrue((byteArrayWrapper != null || file != null ? 1 : 0) != 0, (String)"SrcData or SrcFile must be present");
        ValueEnforcer.isFalse((byteArrayWrapper != null && file != null ? 1 : 0) != 0, (String)"Either SrcData or SrcFile must be present but not both");
        ValueEnforcer.notNull((Object)iMimeType, (String)"MimeType");
        this.m_aDataBytes = byteArrayWrapper;
        this.m_aDataFile = file;
        this.m_sContentID = string;
        this.m_sFilename = string2;
        this.m_aMimeType = iMimeType;
        this.m_eCompressionMode = eAS4CompressionMode;
        this.m_aCharset = charset;
        this.m_aCustomProperties = iCommonsOrderedMap != null ? iCommonsOrderedMap.getClone() : new CommonsLinkedHashMap();
    }

    @Nullable
    public final ByteArrayWrapper getDataBytes() {
        return this.m_aDataBytes;
    }

    public final boolean hasDataBytes() {
        return this.m_aDataBytes != null;
    }

    @Nullable
    public final File getDataFile() {
        return this.m_aDataFile;
    }

    public final boolean hasDataFile() {
        return this.m_aDataFile != null;
    }

    @Nullable
    public final String getContentID() {
        return this.m_sContentID;
    }

    @Nullable
    public final String getFilename() {
        return this.m_sFilename;
    }

    @Nonnull
    public final IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    @Nullable
    public final EAS4CompressionMode getCompressionMode() {
        return this.m_eCompressionMode;
    }

    @Nullable
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsOrderedMap<String, String> customProperties() {
        return this.m_aCustomProperties;
    }

    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<String, String> getAllCustomProperties() {
        return this.m_aCustomProperties.getClone();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DataBytes", (Object)this.m_aDataBytes).append("DataFile", (Object)this.m_aDataFile).append("ContentID", (Object)this.m_sContentID).append("Filename", (Object)this.m_sFilename).append("MimeType", (Object)this.m_aMimeType).append("CompressionMode", (Enum)this.m_eCompressionMode).append("Charset", (Object)this.m_aCharset).append("CustomProperties", this.m_aCustomProperties).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements IBuilder<AS4OutgoingAttachment> {
        private ByteArrayWrapper m_aDataBytes;
        private File m_aDataFile;
        private String m_sContentID;
        private String m_sFilename;
        private IMimeType m_aMimeType;
        private EAS4CompressionMode m_eCompressionMode;
        private Charset m_aCharset;
        private final ICommonsOrderedMap<String, String> m_aCustomProperties = new CommonsLinkedHashMap();

        @Nonnull
        public Builder data(@Nullable byte[] byArray) {
            return this.data(byArray == null ? null : new ByteArrayWrapper(byArray, false));
        }

        @Nonnull
        public Builder data(@Nullable ByteArrayWrapper byteArrayWrapper) {
            this.m_aDataBytes = byteArrayWrapper;
            this.m_aDataFile = null;
            return this;
        }

        @Nonnull
        public Builder data(@Nullable File file) {
            this.m_aDataBytes = null;
            this.m_aDataFile = file;
            return this;
        }

        @Nonnull
        public Builder reandomContentID() {
            return this.contentID(MessageHelperMethods.createRandomContentID());
        }

        @Nonnull
        public Builder contentID(@Nullable String string) {
            this.m_sContentID = string;
            return this;
        }

        @Nonnull
        public Builder filename(@Nullable String string) {
            this.m_sFilename = string;
            return this;
        }

        @Nonnull
        public Builder mimeTypeXML() {
            return this.mimeType(CMimeType.APPLICATION_XML);
        }

        @Nonnull
        public Builder mimeType(@Nullable IMimeType iMimeType) {
            this.m_aMimeType = iMimeType;
            return this;
        }

        @Nonnull
        public Builder compressionGZIP() {
            return this.compression(EAS4CompressionMode.GZIP);
        }

        @Nonnull
        public Builder compression(@Nullable EAS4CompressionMode eAS4CompressionMode) {
            this.m_eCompressionMode = eAS4CompressionMode;
            return this;
        }

        @Nonnull
        public Builder charset(@Nullable Charset charset) {
            this.m_aCharset = charset;
            return this;
        }

        @Nonnull
        public Builder addCustomProperty(@Nullable String string, @Nullable String string2) {
            if (StringHelper.isNotEmpty((String)string)) {
                this.m_aCustomProperties.put((Object)string, (Object)string2);
            }
            return this;
        }

        @Nonnull
        public Builder addCustomProperties(@Nullable ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
            this.m_aCustomProperties.putAllIfNotNull(iCommonsOrderedMap);
            return this;
        }

        @Nonnull
        public Builder customProperty(@Nullable String string, @Nullable String string2) {
            if (StringHelper.isNotEmpty((String)string)) {
                this.m_aCustomProperties.clear();
                this.m_aCustomProperties.put((Object)string, (Object)string2);
            }
            return this;
        }

        @Nonnull
        public Builder customProperties(@Nullable ICommonsOrderedMap<String, String> iCommonsOrderedMap) {
            this.m_aCustomProperties.setAll(iCommonsOrderedMap);
            return this;
        }

        @OverridingMethodsMustInvokeSuper
        protected void checkConsistency() {
            if (this.m_aDataBytes == null && this.m_aDataFile == null) {
                throw new IllegalStateException("Phase4OutgoingAttachment has no 'data' element");
            }
            if (this.m_aMimeType == null) {
                throw new IllegalStateException("Phase4OutgoingAttachment has no 'mimeType' element");
            }
        }

        @Nonnull
        public AS4OutgoingAttachment build() {
            this.checkConsistency();
            return new AS4OutgoingAttachment(this.m_aDataBytes, this.m_aDataFile, this.m_sContentID, this.m_sFilename, this.m_aMimeType, this.m_eCompressionMode, this.m_aCharset, this.m_aCustomProperties);
        }
    }
}

