/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.client;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillNotClose;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.client.AS4ClientBuiltMessage;
import com.helger.phase4.client.AbstractAS4ClientSignalMessage;
import com.helger.phase4.client.IAS4ClientBuildMessageCallback;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3MessageInfo;
import com.helger.phase4.messaging.crypto.AS4Signer;
import com.helger.phase4.messaging.http.HttpXMLEntity;
import com.helger.phase4.model.message.AS4PullRequestMessage;
import com.helger.phase4.model.message.EAS4MessageType;
import com.helger.phase4.model.message.MessageHelperMethods;
import com.helger.phase4.util.AS4ResourceHelper;
import com.helger.xsds.xmldsig.ReferenceType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.w3c.dom.Document;

public class AS4ClientPullRequestMessage
extends AbstractAS4ClientSignalMessage<AS4ClientPullRequestMessage> {
    private String m_sMPC;

    public AS4ClientPullRequestMessage(@Nonnull @WillNotClose AS4ResourceHelper aS4ResourceHelper) {
        super(EAS4MessageType.PULL_REQUEST, aS4ResourceHelper);
    }

    @Nullable
    public final String getMPC() {
        return this.m_sMPC;
    }

    @Nonnull
    public final AS4ClientPullRequestMessage setMPC(@Nullable String string) {
        this.m_sMPC = string;
        return this;
    }

    private void _checkMandatoryAttributes() {
        if (StringHelper.isEmpty((String)this.m_sMPC)) {
            throw new IllegalStateException("An MPC has to be present");
        }
    }

    @Override
    public AS4ClientBuiltMessage buildMessage(@Nonnull @Nonempty String string, @Nullable IAS4ClientBuildMessageCallback iAS4ClientBuildMessageCallback) throws WSSecurityException {
        Document document;
        this._checkMandatoryAttributes();
        Ebms3MessageInfo ebms3MessageInfo = MessageHelperMethods.createEbms3MessageInfo(string, this.getRefToMessageID(), ((AS4ClientPullRequestMessage)this.ensureSendingDateTime()).getSendingDateTime());
        AS4PullRequestMessage aS4PullRequestMessage = AS4PullRequestMessage.create(this.getSoapVersion(), ebms3MessageInfo, this.m_sMPC, (List)this.any().getClone());
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onAS4Message(aS4PullRequestMessage);
        }
        Document document2 = aS4PullRequestMessage.getAsSoapDocument();
        if (iAS4ClientBuildMessageCallback != null) {
            iAS4ClientBuildMessageCallback.onSoapDocument(document2);
        }
        ICommonsList<ReferenceType> iCommonsList = null;
        if (this.signingParams().isSigningEnabled()) {
            IAS4CryptoFactory iAS4CryptoFactory = this.internalGetCryptoFactorySign();
            Document document3 = AS4Signer.createSignedMessage(iAS4CryptoFactory, document2, this.getSoapVersion(), aS4PullRequestMessage.getMessagingID(), null, this.getAS4ResourceHelper(), true, this.signingParams().getClone());
            iCommonsList = MessageHelperMethods.getAllDSigReferences(document3);
            if (iAS4ClientBuildMessageCallback != null) {
                iAS4ClientBuildMessageCallback.onSignedSoapDocument(document3);
            }
            document = document3;
        } else {
            document = document2;
        }
        return new AS4ClientBuiltMessage(string, new HttpXMLEntity(document, this.getSoapVersion().getMimeType()), iCommonsList);
    }
}

