/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.dump;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingByteArrayInputStream;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.numeric.mutable.MutableInt;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.mime.IMimeType;
import com.helger.phase4.attachment.IAS4IncomingAttachmentFactory;
import com.helger.phase4.attachment.WSS4JAttachment;
import com.helger.phase4.crypto.IAS4CryptoFactory;
import com.helger.phase4.ebms3header.Ebms3Error;
import com.helger.phase4.ebms3header.Ebms3SignalMessage;
import com.helger.phase4.ebms3header.Ebms3UserMessage;
import com.helger.phase4.incoming.AS4IncomingMessageMetadata;
import com.helger.phase4.incoming.AS4IncomingProfileSelectorConstant;
import com.helger.phase4.incoming.AS4IncomingReceiverConfiguration;
import com.helger.phase4.incoming.AS4RequestHandler;
import com.helger.phase4.incoming.IAS4IncomingMessageMetadata;
import com.helger.phase4.incoming.IAS4IncomingMessageState;
import com.helger.phase4.incoming.IAS4ResponseAbstraction;
import com.helger.phase4.incoming.crypto.AS4IncomingSecurityConfiguration;
import com.helger.phase4.incoming.spi.AS4MessageProcessorResult;
import com.helger.phase4.incoming.spi.AS4SignalMessageProcessorResult;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessorSPI;
import com.helger.phase4.logging.Phase4LoggerFactory;
import com.helger.phase4.model.pmode.IPMode;
import com.helger.phase4.model.pmode.resolve.AS4DefaultPModeResolver;
import com.helger.phase4.util.Phase4Exception;
import com.helger.servlet.mock.MockServletContext;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.mgr.WebScoped;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public final class AS4DumpReader {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4DumpReader.class);

    private AS4DumpReader() {
    }

    public static void readAndSkipInitialHttpHeaders(@Nonnull byte[] byArray, @Nullable Consumer<HttpHeaderMap> consumer, @Nullable IntConsumer intConsumer) {
        ValueEnforcer.notNull((Object)byArray, (String)"AS4InData");
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == 10) {
                if (bl) {
                    n2 = i;
                    break;
                }
                bl = true;
                String string = new String(byArray, n, i - n, StandardCharsets.ISO_8859_1);
                String[] stringArray = StringHelper.getExplodedArray((char)':', (String)string, (int)2);
                httpHeaderMap.addHeader(stringArray[0].trim(), stringArray[1].trim());
                n = i + 1;
                continue;
            }
            if (by == 13) continue;
            bl = false;
        }
        if (consumer != null) {
            consumer.accept(httpHeaderMap);
        }
        if (intConsumer != null) {
            intConsumer.accept(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptAS4In(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nonnull IAS4CryptoFactory iAS4CryptoFactory, @Nonnull IAS4CryptoFactory iAS4CryptoFactory2, @Nullable Consumer<HttpHeaderMap> consumer, final @Nonnull IDecryptedPayloadConsumer iDecryptedPayloadConsumer) throws WSSecurityException, Phase4Exception, IOException, MessagingException {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"AS4ProfileID");
        ValueEnforcer.notNull((Object)byArray, (String)"AS4InData");
        ValueEnforcer.notNull((Object)iAS4CryptoFactory, (String)"CryptoFactorySign");
        ValueEnforcer.notNull((Object)iAS4CryptoFactory2, (String)"CryptoFactoryCrypt");
        ValueEnforcer.notNull((Object)iDecryptedPayloadConsumer, (String)"DecryptedConsumer");
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        MutableInt mutableInt = new MutableInt(-1);
        AS4DumpReader.readAndSkipInitialHttpHeaders(byArray, arg_0 -> ((HttpHeaderMap)httpHeaderMap).setAllHeaders(arg_0), arg_0 -> ((MutableInt)mutableInt).set(arg_0));
        int n = mutableInt.intValue();
        if (consumer != null) {
            consumer.accept(httpHeaderMap);
        }
        LOGGER.info("Now at byte " + n + " having " + httpHeaderMap.size() + " HTTP headers");
        boolean bl = WebScopeManager.isGlobalScopePresent();
        if (!bl) {
            WebScopeManager.onGlobalBegin((ServletContext)MockServletContext.create());
        }
        try (WebScoped webScoped = new WebScoped();
             AS4RequestHandler aS4RequestHandler = new AS4RequestHandler(AS4IncomingMessageMetadata.createForRequest());){
            aS4RequestHandler.setCryptoFactorySign(iAS4CryptoFactory);
            aS4RequestHandler.setCryptoFactoryCrypt(iAS4CryptoFactory2);
            aS4RequestHandler.setPModeResolver(new AS4DefaultPModeResolver(string));
            aS4RequestHandler.setIncomingProfileSelector(new AS4IncomingProfileSelectorConstant(string));
            aS4RequestHandler.setIncomingAttachmentFactory(IAS4IncomingAttachmentFactory.DEFAULT_INSTANCE);
            aS4RequestHandler.setIncomingSecurityConfiguration(AS4IncomingSecurityConfiguration.createDefaultInstance());
            aS4RequestHandler.setIncomingReceiverConfiguration(new AS4IncomingReceiverConfiguration());
            IAS4IncomingMessageProcessorSPI iAS4IncomingMessageProcessorSPI = new IAS4IncomingMessageProcessorSPI(){

                @Override
                public AS4MessageProcessorResult processAS4UserMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull HttpHeaderMap httpHeaderMap, @Nonnull Ebms3UserMessage ebms3UserMessage, @Nonnull IPMode iPMode, @Nullable Node node, @Nullable ICommonsList<WSS4JAttachment> iCommonsList, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull ICommonsList<Ebms3Error> iCommonsList2) {
                    try {
                        int n = 0;
                        if (iCommonsList != null) {
                            for (WSS4JAttachment wSS4JAttachment : iCommonsList) {
                                byte[] byArray = StreamHelper.getAllBytes((IHasInputStream)wSS4JAttachment.getInputStreamProvider());
                                if (byArray == null) {
                                    LOGGER.error("Failed to read decrypted payload of attachment #" + n);
                                } else {
                                    iDecryptedPayloadConsumer.accept(n, byArray);
                                    LOGGER.info("Handled decrypted payload #" + n + " with " + byArray.length + " bytes");
                                }
                                ++n;
                            }
                        }
                        return AS4MessageProcessorResult.createSuccess();
                    }
                    catch (Exception exception) {
                        throw new IllegalStateException(exception);
                    }
                }

                @Override
                public AS4SignalMessageProcessorResult processAS4SignalMessage(IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, HttpHeaderMap httpHeaderMap, Ebms3SignalMessage ebms3SignalMessage, IPMode iPMode, IAS4IncomingMessageState iAS4IncomingMessageState, ICommonsList<Ebms3Error> iCommonsList) {
                    LOGGER.error("Unexpected signal msg. Can only handle user messages.");
                    return AS4SignalMessageProcessorResult.createSuccess();
                }

                @Override
                public void processAS4ResponseMessage(@Nonnull IAS4IncomingMessageMetadata iAS4IncomingMessageMetadata, @Nonnull IAS4IncomingMessageState iAS4IncomingMessageState, @Nonnull @Nonempty String string, @Nullable byte[] byArray, boolean bl) {
                }
            };
            aS4RequestHandler.setProcessorSupplier(() -> new CommonsArrayList((Object)iAS4IncomingMessageProcessorSPI));
            aS4RequestHandler.handleRequest((InputStream)new NonBlockingByteArrayInputStream(byArray, n, byArray.length - n), httpHeaderMap, new IAS4ResponseAbstraction(){

                @Override
                public void setStatus(int n) {
                }

                @Override
                public void setMimeType(IMimeType iMimeType) {
                }

                @Override
                public void setContent(HttpHeaderMap httpHeaderMap, IHasInputStream iHasInputStream) {
                }

                @Override
                public void setContent(byte[] byArray, Charset charset) {
                }
            });
        }
        finally {
            if (!bl) {
                WebScopeManager.onGlobalEnd();
            }
        }
    }

    @FunctionalInterface
    public static interface IDecryptedPayloadConsumer {
        public void accept(@Nonnegative int var1, @Nonnull byte[] var2);
    }
}

