/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming;

import com.helger.annotation.CheckForSigned;
import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.ICommonsList;
import com.helger.http.header.HttpHeaderMap;
import com.helger.phase4.messaging.EAS4MessageMode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.Cookie;
import java.security.cert.X509Certificate;
import java.time.OffsetDateTime;

public interface IAS4IncomingMessageMetadata {
    @Nonnull
    @Nonempty
    public String getIncomingUniqueID();

    @Nonnull
    public OffsetDateTime getIncomingDT();

    @Nonnull
    public EAS4MessageMode getMode();

    @Nullable
    public String getRemoteAddr();

    default public boolean hasRemoteAddr() {
        return StringHelper.isNotEmpty((String)this.getRemoteAddr());
    }

    @Nullable
    public String getRemoteHost();

    default public boolean hasRemoteHost() {
        return StringHelper.isNotEmpty((String)this.getRemoteHost());
    }

    @CheckForSigned
    public int getRemotePort();

    default public boolean hasRemotePort() {
        return this.getRemotePort() > 0;
    }

    @Nullable
    public String getRemoteUser();

    default public boolean hasRemoteUser() {
        return StringHelper.isNotEmpty((String)this.getRemoteUser());
    }

    @Nullable
    @ReturnsMutableObject
    public ICommonsList<X509Certificate> remoteTlsCerts();

    default public boolean hasRemoteTlsCerts() {
        return this.remoteTlsCerts() != null && this.remoteTlsCerts().isNotEmpty();
    }

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<Cookie> cookies();

    @Nonnull
    @ReturnsMutableObject
    default public ICommonsList<Cookie> getAllCookies() {
        return (ICommonsList)this.cookies().getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getAllHttpHeaders();

    @Nullable
    public String getRequestMessageID();
}

