/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.incoming.mgr;

import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.phase4.incoming.spi.IAS4IncomingMessageProcessorSPI;
import com.helger.phase4.logging.Phase4LoggerFactory;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;

@ThreadSafe
public final class AS4IncomingMessageProcessorManager {
    private static final Logger LOGGER = Phase4LoggerFactory.getLogger(AS4IncomingMessageProcessorManager.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static final ICommonsList<IAS4IncomingMessageProcessorSPI> PROCESSORS = new CommonsArrayList();

    private AS4IncomingMessageProcessorManager() {
    }

    public static void reinitProcessors() {
        List list = ServiceLoaderHelper.getAllSPIImplementations(IAS4IncomingMessageProcessorSPI.class);
        if (list.isEmpty()) {
            LOGGER.warn("No AS4 message processor is registered. All incoming messages will be positively responded and discarded on the receiver side!");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found " + list.size() + " AS4 message processors");
        }
        RW_LOCK.writeLocked(() -> PROCESSORS.setAll((Iterable)list));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAS4IncomingMessageProcessorSPI> getAllProcessors() {
        return (ICommonsList)RW_LOCK.readLockedGet(() -> PROCESSORS.getClone());
    }

    static {
        AS4IncomingMessageProcessorManager.reinitProcessors();
    }
}

