/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.logging;

import com.helger.base.enforce.ValueEnforcer;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.spi.LoggingEventBuilder;

public final class Phase4DelegatedLogger
implements Logger {
    private final Logger m_aDelegate;
    private final Function<String, String> m_aMsgCustomizer;

    public Phase4DelegatedLogger(@Nonnull Logger logger, @Nonnull Function<String, String> function) {
        ValueEnforcer.notNull((Object)logger, (String)"Delegate");
        ValueEnforcer.notNull(function, (String)"MsgCustomizer");
        this.m_aDelegate = logger;
        this.m_aMsgCustomizer = function;
    }

    @Nonnull
    private String _getCustomized(@Nullable String string) {
        return this.m_aMsgCustomizer.apply(string);
    }

    public String getName() {
        return this.m_aDelegate.getName();
    }

    public LoggingEventBuilder makeLoggingEventBuilder(Level level) {
        return this.m_aDelegate.makeLoggingEventBuilder(level);
    }

    public LoggingEventBuilder atLevel(Level level) {
        return this.m_aDelegate.atLevel(level);
    }

    public boolean isEnabledForLevel(Level level) {
        return this.m_aDelegate.isEnabledForLevel(level);
    }

    public boolean isTraceEnabled() {
        return this.m_aDelegate.isTraceEnabled();
    }

    public void trace(String string) {
        this.m_aDelegate.trace(this._getCustomized(string));
    }

    public void trace(String string, Object object) {
        this.m_aDelegate.trace(this._getCustomized(string), object);
    }

    public void trace(String string, Object object, Object object2) {
        this.m_aDelegate.trace(this._getCustomized(string), object, object2);
    }

    public void trace(String string, Object ... objectArray) {
        this.m_aDelegate.trace(this._getCustomized(string), objectArray);
    }

    public void trace(String string, Throwable throwable) {
        this.m_aDelegate.trace(this._getCustomized(string), throwable);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.m_aDelegate.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String string) {
        this.m_aDelegate.trace(marker, this._getCustomized(string));
    }

    public void trace(Marker marker, String string, Object object) {
        this.m_aDelegate.trace(marker, this._getCustomized(string), object);
    }

    public void trace(Marker marker, String string, Object object, Object object2) {
        this.m_aDelegate.trace(marker, this._getCustomized(string), object, object2);
    }

    public void trace(Marker marker, String string, Object ... objectArray) {
        this.m_aDelegate.trace(marker, this._getCustomized(string), objectArray);
    }

    public void trace(Marker marker, String string, Throwable throwable) {
        this.m_aDelegate.trace(marker, this._getCustomized(string), throwable);
    }

    public LoggingEventBuilder atTrace() {
        return this.m_aDelegate.atTrace();
    }

    public boolean isDebugEnabled() {
        return this.m_aDelegate.isDebugEnabled();
    }

    public void debug(String string) {
        this.m_aDelegate.debug(this._getCustomized(string));
    }

    public void debug(String string, Object object) {
        this.m_aDelegate.debug(this._getCustomized(string), object);
    }

    public void debug(String string, Object object, Object object2) {
        this.m_aDelegate.debug(this._getCustomized(string), object, object2);
    }

    public void debug(String string, Object ... objectArray) {
        this.m_aDelegate.debug(this._getCustomized(string), objectArray);
    }

    public void debug(String string, Throwable throwable) {
        this.m_aDelegate.debug(this._getCustomized(string), throwable);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.m_aDelegate.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String string) {
        this.m_aDelegate.debug(marker, this._getCustomized(string));
    }

    public void debug(Marker marker, String string, Object object) {
        this.m_aDelegate.debug(marker, this._getCustomized(string), object);
    }

    public void debug(Marker marker, String string, Object object, Object object2) {
        this.m_aDelegate.debug(marker, this._getCustomized(string), object, object2);
    }

    public void debug(Marker marker, String string, Object ... objectArray) {
        this.m_aDelegate.debug(marker, this._getCustomized(string), objectArray);
    }

    public void debug(Marker marker, String string, Throwable throwable) {
        this.m_aDelegate.debug(marker, this._getCustomized(string), throwable);
    }

    public LoggingEventBuilder atDebug() {
        return this.m_aDelegate.atDebug();
    }

    public boolean isInfoEnabled() {
        return this.m_aDelegate.isInfoEnabled();
    }

    public void info(String string) {
        this.m_aDelegate.info(this._getCustomized(string));
    }

    public void info(String string, Object object) {
        this.m_aDelegate.info(this._getCustomized(string), object);
    }

    public void info(String string, Object object, Object object2) {
        this.m_aDelegate.info(this._getCustomized(string), object, object2);
    }

    public void info(String string, Object ... objectArray) {
        this.m_aDelegate.info(this._getCustomized(string), objectArray);
    }

    public void info(String string, Throwable throwable) {
        this.m_aDelegate.info(this._getCustomized(string), throwable);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.m_aDelegate.isInfoEnabled(marker);
    }

    public void info(Marker marker, String string) {
        this.m_aDelegate.info(marker, this._getCustomized(string));
    }

    public void info(Marker marker, String string, Object object) {
        this.m_aDelegate.info(marker, this._getCustomized(string), object);
    }

    public void info(Marker marker, String string, Object object, Object object2) {
        this.m_aDelegate.info(marker, this._getCustomized(string), object, object2);
    }

    public void info(Marker marker, String string, Object ... objectArray) {
        this.m_aDelegate.info(marker, this._getCustomized(string), objectArray);
    }

    public void info(Marker marker, String string, Throwable throwable) {
        this.m_aDelegate.info(marker, this._getCustomized(string), throwable);
    }

    public LoggingEventBuilder atInfo() {
        return this.m_aDelegate.atInfo();
    }

    public boolean isWarnEnabled() {
        return this.m_aDelegate.isWarnEnabled();
    }

    public void warn(String string) {
        this.m_aDelegate.warn(this._getCustomized(string));
    }

    public void warn(String string, Object object) {
        this.m_aDelegate.warn(this._getCustomized(string), object);
    }

    public void warn(String string, Object object, Object object2) {
        this.m_aDelegate.warn(this._getCustomized(string), object, object2);
    }

    public void warn(String string, Object ... objectArray) {
        this.m_aDelegate.warn(this._getCustomized(string), objectArray);
    }

    public void warn(String string, Throwable throwable) {
        this.m_aDelegate.warn(this._getCustomized(string), throwable);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.m_aDelegate.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String string) {
        this.m_aDelegate.warn(marker, this._getCustomized(string));
    }

    public void warn(Marker marker, String string, Object object) {
        this.m_aDelegate.warn(marker, this._getCustomized(string), object);
    }

    public void warn(Marker marker, String string, Object object, Object object2) {
        this.m_aDelegate.warn(marker, this._getCustomized(string), object, object2);
    }

    public void warn(Marker marker, String string, Object ... objectArray) {
        this.m_aDelegate.warn(marker, this._getCustomized(string), objectArray);
    }

    public void warn(Marker marker, String string, Throwable throwable) {
        this.m_aDelegate.warn(marker, this._getCustomized(string), throwable);
    }

    public LoggingEventBuilder atWarn() {
        return this.m_aDelegate.atWarn();
    }

    public boolean isErrorEnabled() {
        return this.m_aDelegate.isErrorEnabled();
    }

    public void error(String string) {
        this.m_aDelegate.error(this._getCustomized(string));
    }

    public void error(String string, Object object) {
        this.m_aDelegate.error(this._getCustomized(string), object);
    }

    public void error(String string, Object object, Object object2) {
        this.m_aDelegate.error(this._getCustomized(string), object, object2);
    }

    public void error(String string, Object ... objectArray) {
        this.m_aDelegate.error(this._getCustomized(string), objectArray);
    }

    public void error(String string, Throwable throwable) {
        this.m_aDelegate.error(this._getCustomized(string), throwable);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.m_aDelegate.isErrorEnabled(marker);
    }

    public void error(Marker marker, String string) {
        this.m_aDelegate.error(marker, this._getCustomized(string));
    }

    public void error(Marker marker, String string, Object object) {
        this.m_aDelegate.error(marker, this._getCustomized(string), object);
    }

    public void error(Marker marker, String string, Object object, Object object2) {
        this.m_aDelegate.error(marker, this._getCustomized(string), object, object2);
    }

    public void error(Marker marker, String string, Object ... objectArray) {
        this.m_aDelegate.error(marker, this._getCustomized(string), objectArray);
    }

    public void error(Marker marker, String string, Throwable throwable) {
        this.m_aDelegate.error(marker, this._getCustomized(string), throwable);
    }

    public LoggingEventBuilder atError() {
        return this.m_aDelegate.atError();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Phase4DelegatedLogger phase4DelegatedLogger = (Phase4DelegatedLogger)object;
        return this.m_aDelegate.equals((Object)phase4DelegatedLogger.m_aDelegate);
    }

    public int hashCode() {
        return this.m_aDelegate.hashCode();
    }
}

