/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.messaging.http;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.BigHelper;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import java.math.BigDecimal;
import java.time.Duration;

@NotThreadSafe
public class HttpRetrySettings {
    public static final int DEFAULT_MAX_RETRIES = 0;
    public static final Duration DEFAULT_RETRY_DURATION = Duration.ofSeconds(10L);
    public static final BigDecimal DEFAULT_RETRY_INCREASE_FACTOR = BigDecimal.ONE;
    private int m_nMaxRetries = 0;
    private Duration m_aDurationBeforeRetry = DEFAULT_RETRY_DURATION;
    private BigDecimal m_aRetryIncreaseFactor = DEFAULT_RETRY_INCREASE_FACTOR;

    public boolean isRetryEnabled() {
        return this.m_nMaxRetries > 0;
    }

    public final int getMaxRetries() {
        return this.m_nMaxRetries;
    }

    @Nonnull
    public final HttpRetrySettings setMaxRetries(int n) {
        this.m_nMaxRetries = n;
        return this;
    }

    @Nonnull
    public final Duration getDurationBeforeRetry() {
        return this.m_aDurationBeforeRetry;
    }

    @Nonnull
    public final HttpRetrySettings setDurationBeforeRetry(@Nonnull Duration duration) {
        ValueEnforcer.notNull((Object)duration, (String)"DurationBeforeRetry");
        this.m_aDurationBeforeRetry = duration;
        return this;
    }

    @Nonnull
    @Nonnegative
    public final BigDecimal getRetryIncreaseFactor() {
        return this.m_aRetryIncreaseFactor;
    }

    @Nonnull
    public final HttpRetrySettings setRetryIncreaseFactor(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.isGT0((BigDecimal)bigDecimal, (String)"RetryIncreaseFactor");
        this.m_aRetryIncreaseFactor = bigDecimal;
        return this;
    }

    @Nonnull
    public static Duration getIncreased(@Nonnull Duration duration, @Nonnull BigDecimal bigDecimal) {
        if (BigHelper.isEQ0((BigDecimal)bigDecimal)) {
            return Duration.ZERO;
        }
        if (BigHelper.isEQ1((BigDecimal)bigDecimal)) {
            return duration;
        }
        return Duration.ofNanos(bigDecimal.multiply(BigDecimal.valueOf(duration.toNanos())).longValue());
    }

    public final void assignFrom(@Nonnull HttpRetrySettings httpRetrySettings) {
        ValueEnforcer.notNull((Object)httpRetrySettings, (String)"Other");
        this.setMaxRetries(httpRetrySettings.getMaxRetries());
        this.setDurationBeforeRetry(httpRetrySettings.getDurationBeforeRetry());
        this.setRetryIncreaseFactor(httpRetrySettings.getRetryIncreaseFactor());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        HttpRetrySettings httpRetrySettings = (HttpRetrySettings)object;
        return this.m_nMaxRetries == httpRetrySettings.m_nMaxRetries && this.m_aDurationBeforeRetry.equals(httpRetrySettings.m_aDurationBeforeRetry) && EqualsHelper.equals((Object)this.m_aRetryIncreaseFactor, (Object)httpRetrySettings.m_aRetryIncreaseFactor);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMaxRetries).append((Object)this.m_aDurationBeforeRetry).append((Object)this.m_aRetryIncreaseFactor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("MaxRetries", this.m_nMaxRetries).append("DurationBeforeRetry", (Object)this.m_aDurationBeforeRetry).append("RetryIncreaseFactor", (Object)this.m_aRetryIncreaseFactor).getToString();
    }
}

