/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phase4.model.message;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasDisplayName;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public enum EAS4MessageType implements IHasID<String>,
IHasDisplayName
{
    ERROR_MESSAGE("errormsg", "Error Message"),
    PULL_REQUEST("pullreq", "Pull Request"),
    RECEIPT("receipt", "Receipt"),
    USER_MESSAGE("usermsg", "User Message");

    private final String m_sID;
    private final String m_sDisplayName;

    private EAS4MessageType(String string2, String string3) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    public boolean isUserMessage() {
        return this == USER_MESSAGE;
    }

    public boolean isSignalMessage() {
        return this != USER_MESSAGE;
    }

    public boolean isReceiptOrError() {
        return this == RECEIPT || this == ERROR_MESSAGE;
    }

    @Nullable
    public static EAS4MessageType getFromIDOrNull(@Nullable String string) {
        return (EAS4MessageType)EnumHelper.getFromIDOrNull(EAS4MessageType.class, (Object)string);
    }
}

