/*
 * Decompiled with CFR 0.152.
 */
package com.helger.phive.api.source;

import com.helger.annotation.Nonempty;
import com.helger.annotation.WillNotClose;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.phive.api.source.IValidationSourceBinary;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.OutputStream;

public class ValidationSourceBinary
implements IValidationSourceBinary {
    private final String m_sSystemID;
    private final boolean m_bPartialSource;
    private final ByteArrayWrapper m_aBAW;

    protected ValidationSourceBinary(@Nullable String string, @Nonnull ByteArrayWrapper byteArrayWrapper, boolean bl) {
        ValueEnforcer.notNull((Object)byteArrayWrapper, (String)"BAW");
        this.m_sSystemID = string;
        this.m_aBAW = byteArrayWrapper;
        this.m_bPartialSource = bl;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getValidationSourceTypeID() {
        return "binary";
    }

    @Override
    @Nullable
    public String getSystemID() {
        return this.m_sSystemID;
    }

    @Override
    public boolean isPartialSource() {
        return this.m_bPartialSource;
    }

    @Override
    @Nullable
    public ByteArrayWrapper getBytes() {
        return this.m_aBAW;
    }

    @Override
    public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        this.m_aBAW.writeTo(outputStream);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("SystemID", (Object)this.m_sSystemID).append("PartialSource", this.m_bPartialSource).append("ByteArrayWrapper", (Object)this.m_aBAW).getToString();
    }

    @Nonnull
    public static ValidationSourceBinary create(@Nullable String string, @Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        return new ValidationSourceBinary(string, new ByteArrayWrapper(byArray, false), false);
    }

    @Nonnull
    public static ValidationSourceBinary createPartial(@Nullable String string, @Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        return new ValidationSourceBinary(string, new ByteArrayWrapper(byArray, false), true);
    }
}

