/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.clazz.ClassHelper;
import com.helger.collection.commons.CommonsArrayList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.hc.client5.http.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

@Immutable
public class NonCachingDnsResolver
implements DnsResolver {
    public static final NonCachingDnsResolver INSTANCE = new NonCachingDnsResolver();
    private static final Logger LOGGER = LoggerFactory.getLogger(NonCachingDnsResolver.class);

    @Nonnull
    public static Lookup createDefaultLookup(@Nonnull String string) throws TextParseException {
        return NonCachingDnsResolver.createDefaultLookup(string, 1);
    }

    @Nonnull
    public static Lookup createDefaultLookup(@Nonnull String string, int n) throws TextParseException {
        Lookup lookup = new Lookup(string, n);
        try {
            lookup.setResolver((Resolver)new SimpleResolver());
        }
        catch (UnknownHostException unknownHostException) {
            LOGGER.warn("Failed to set SimpleResolver to DNSLookup", (Throwable)unknownHostException);
        }
        lookup.setCache(null);
        return lookup;
    }

    @Nonnull
    protected Lookup createLookup(@Nonnull String string) throws TextParseException {
        return NonCachingDnsResolver.createDefaultLookup(string);
    }

    @Nonnull
    public InetAddress[] resolveExt(@Nonnull String string, @Nullable Consumer<? super Record> consumer) throws UnknownHostException {
        Object[] objectArray;
        Object object;
        ValueEnforcer.notNull((Object)string, (String)"Host");
        Object object2 = object = string.endsWith(".") ? string : string + ".";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DNS resolving host '" + (String)object + "'");
        }
        Record[] recordArray = null;
        try {
            objectArray = this.createLookup((String)object);
            recordArray = objectArray.run();
        }
        catch (TextParseException textParseException) {
            LOGGER.error("Failed to parse host '" + (String)object + "'", (Throwable)textParseException);
        }
        if (recordArray == null || recordArray.length == 0) {
            objectArray = InetAddress.getAllByName((String)object);
        } else {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (Record record : recordArray) {
                Object object3;
                if (consumer != null) {
                    consumer.accept((Record)record);
                }
                if (record instanceof CNAMERecord) {
                    object3 = ((CNAMERecord)record).getTarget().toString();
                    if (((String)object3).equals(object)) {
                        LOGGER.warn("Target record is the same as the request '" + (String)object3 + "' - avoid endless recursion");
                        continue;
                    }
                    Object[] objectArray2 = this.resolve((String)object3);
                    if (objectArray2 == null) continue;
                    commonsArrayList.addAll(objectArray2);
                    continue;
                }
                if (record instanceof ARecord) {
                    object3 = ((ARecord)record).getAddress();
                    commonsArrayList.add(object3);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Unknown record type found for host '" + (String)object + "': " + ClassHelper.getClassLocalName((Object)record));
            }
            objectArray = (InetAddress[])commonsArrayList.toArray((Object[])new InetAddress[commonsArrayList.size()]);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Return for '" + (String)object + "': " + Arrays.toString(objectArray));
        }
        return objectArray;
    }

    @Nonnull
    public InetAddress[] resolve(@Nonnull String string) throws UnknownHostException {
        return this.resolveExt(string, null);
    }

    @Nonnull
    public String resolveCanonicalHostname(@Nonnull String string) throws UnknownHostException {
        InetAddress[] inetAddressArray = this.resolve(string);
        if (inetAddressArray.length > 0) {
            return inetAddressArray[0].getCanonicalHostName();
        }
        return string;
    }
}

