/*
 * Decompiled with CFR 0.152.
 */
package com.helger.httpclient.response;

import com.helger.base.string.StringHelper;
import com.helger.httpclient.HttpClientHelper;
import com.helger.httpclient.response.ResponseHandlerHttpEntity;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerMicroDom
implements HttpClientResponseHandler<IMicroDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHandlerMicroDom.class);
    private boolean m_bDebugMode;

    public final boolean isDebugMode() {
        return this.m_bDebugMode;
    }

    @Nonnull
    public final ResponseHandlerMicroDom setDebugMode(boolean bl) {
        this.m_bDebugMode = bl;
        return this;
    }

    @Nullable
    public IMicroDocument handleResponse(@Nonnull ClassicHttpResponse classicHttpResponse) throws IOException {
        HttpEntity httpEntity = ResponseHandlerHttpEntity.INSTANCE.handleResponse(classicHttpResponse);
        if (httpEntity == null) {
            throw new ClientProtocolException("Response contains no content");
        }
        if (this.m_bDebugMode) {
            ContentType contentType = HttpClientHelper.getContentTypeOrDefault(httpEntity);
            Charset charset = HttpClientHelper.getCharset(contentType, StandardCharsets.UTF_8);
            String string = StringHelper.trim((String)HttpClientHelper.entityToString(httpEntity, charset));
            LOGGER.info("Got XML in [" + String.valueOf(charset) + "]: <" + string + ">");
            IMicroDocument iMicroDocument = MicroReader.readMicroXML((String)string);
            if (iMicroDocument == null) {
                throw new IllegalArgumentException("Failed to parse as XML: " + string);
            }
            return iMicroDocument;
        }
        return MicroReader.readMicroXML((InputStream)httpEntity.getContent());
    }
}

