/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp;

import com.hierynomus.protocol.commons.ByteArrayUtils;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;

public class SID {
    public static final SID EVERYONE = new SID(1, new byte[]{0, 0, 0, 0, 0, 1}, new long[]{0L});
    private byte revision;
    private byte[] sidIdentifierAuthority;
    private long[] subAuthorities;

    public SID() {
    }

    public SID(byte revision, byte[] sidIdentifierAuthority, long[] subAuthorities) {
        this.revision = revision;
        this.sidIdentifierAuthority = sidIdentifierAuthority;
        this.subAuthorities = subAuthorities;
    }

    public void write(SMBBuffer buffer) {
        buffer.putByte(this.revision);
        buffer.putByte((byte)this.subAuthorities.length);
        if (this.sidIdentifierAuthority.length > 6) {
            throw new IllegalArgumentException("The IdentifierAuthority can not be larger than 6 bytes");
        }
        buffer.putRawBytes(this.sidIdentifierAuthority);
        for (int i = 0; i < this.subAuthorities.length; ++i) {
            buffer.putUInt32(this.subAuthorities[i]);
        }
    }

    public void read(SMBBuffer buffer) throws Buffer.BufferException {
        this.revision = buffer.readByte();
        int subAuthorityCount = buffer.readByte();
        this.sidIdentifierAuthority = buffer.readRawBytes(6);
        this.subAuthorities = new long[subAuthorityCount];
        for (int i = 0; i < subAuthorityCount; ++i) {
            this.subAuthorities[i] = buffer.readUInt32();
        }
    }

    public int byteCount() {
        return 8 + this.subAuthorities.length * 4;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("S-");
        b.append(this.revision & 0xFF).append("-");
        if (this.sidIdentifierAuthority[0] != 0 || this.sidIdentifierAuthority[1] != 0) {
            b.append("0x");
            b.append(ByteArrayUtils.printHex(this.sidIdentifierAuthority, 0, 6));
        } else {
            long shift = 0L;
            long id = 0L;
            for (int i = 5; i > 1; --i) {
                id += ((long)this.sidIdentifierAuthority[i] & 0xFFL) << (int)shift;
                shift += 8L;
            }
            b.append(id);
        }
        for (int i = 0; i < this.subAuthorities.length; ++i) {
            b.append("-").append(this.subAuthorities[i] & 0xFFFFFFFFL);
        }
        return b.toString();
    }

    public byte getRevision() {
        return this.revision;
    }

    public byte[] getSidIdentifierAuthority() {
        return this.sidIdentifierAuthority;
    }

    public long[] getSubAuthorities() {
        return this.subAuthorities;
    }

    public static enum SidType implements EnumWithValue<SidType>
    {
        SID_TYPE_NONE(0L, "0"),
        SID_TYPE_USER(1L, "User"),
        SID_TYPE_DOM_GRP(2L, "Domain group"),
        SID_TYPE_DOMAIN(3L, "Domain"),
        SID_TYPE_ALIAS(4L, "Local group"),
        SID_TYPE_WKN_GRP(5L, "Builtin group"),
        SID_TYPE_DELETED(6L, "Deleted"),
        SID_TYPE_INVALID(7L, "Invalid"),
        SID_TYPE_UNKNOWN(8L, "Unknown"),
        SID_TYPE_COMPUTER(9L, "Computer"),
        SID_TYPE_LABEL(10L, "Label");

        private long value;
        private String name;

        private SidType(long value, String name) {
            this.value = value;
            this.name = name;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }
    }
}

