/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msfscc.fileinformation;

import com.hierynomus.msdtyp.MsDataTypes;
import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.msfscc.fileinformation.FileInfo;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileInformationFactory {
    public static byte[] getRenameInfo(boolean replaceIfExists, String newName) {
        Buffer.PlainBuffer renBuf = new Buffer.PlainBuffer(Endian.LE);
        renBuf.putByte((byte)(replaceIfExists ? 1 : 0));
        renBuf.putRawBytes(new byte[]{0, 0, 0, 0, 0, 0, 0});
        renBuf.putUInt64(0L);
        renBuf.putUInt32(newName.length() * 2);
        renBuf.putRawBytes(newName.getBytes(StandardCharsets.UTF_16));
        return renBuf.getCompactData();
    }

    public static byte[] getFileDispositionInfo(boolean deleteOnClose) {
        Buffer.PlainBuffer fileDispBuf = new Buffer.PlainBuffer(Endian.LE);
        fileDispBuf.putByte((byte)(deleteOnClose ? 1 : 0));
        return fileDispBuf.getCompactData();
    }

    public static List<FileInfo> parseFileInformationList(byte[] data, FileInformationClass fileInformationClass) throws Buffer.BufferException {
        int offsetStart;
        Buffer.PlainBuffer buffer = new Buffer.PlainBuffer(data, Endian.LE);
        ArrayList<FileInfo> _fileInfoList = new ArrayList<FileInfo>();
        int nextEntryOffset = offsetStart = 0;
        long fileIndex = 0L;
        do {
            nextEntryOffset = (int)buffer.readUInt32();
            fileIndex = buffer.readUInt32();
            FileInfo fileInfo = null;
            switch (fileInformationClass) {
                case FileIdBothDirectoryInformation: {
                    fileInfo = FileInformationFactory.parseFileIdBothDirectoryInformation(buffer);
                    break;
                }
                case FileAllInformation: {
                    fileInfo = FileInformationFactory.parseFileAllInformation(buffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("FileInformationClass not supported - " + fileInformationClass);
                }
            }
            if (!".".equals(fileInfo.getFileName()) && !"..".equals(fileInfo.getFileName())) {
                _fileInfoList.add(fileInfo);
            }
            buffer.rpos(offsetStart += nextEntryOffset);
        } while (nextEntryOffset != 0);
        return _fileInfoList;
    }

    public static FileInfo parseFileAllInformation(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        Date creationTime = MsDataTypes.readFileTime(buffer);
        Date lastAccessTime = MsDataTypes.readFileTime(buffer);
        Date lastWriteTime = MsDataTypes.readFileTime(buffer);
        Date changeTime = MsDataTypes.readFileTime(buffer);
        long fileAttributes = buffer.readUInt32();
        buffer.skip(4);
        buffer.skip(8);
        long fileSize = buffer.readUInt64();
        buffer.skip(4);
        buffer.skip(1);
        buffer.skip(1);
        buffer.skip(2);
        byte[] fileId = buffer.readRawBytes(8);
        buffer.skip(4);
        long accessMask = buffer.readUInt32();
        buffer.skip(8);
        buffer.skip(4);
        buffer.skip(4);
        long fileNameLen = buffer.readUInt32();
        String fileName = buffer.readString(StandardCharsets.UTF_16LE, (int)fileNameLen / 2);
        FileInfo fi = new FileInfo(fileName, fileId, fileAttributes, fileSize, accessMask);
        return fi;
    }

    public static FileInfo parseFileIdBothDirectoryInformation(Buffer.PlainBuffer buffer) throws Buffer.BufferException {
        Date creationTime = MsDataTypes.readFileTime(buffer);
        Date lastAccessTime = MsDataTypes.readFileTime(buffer);
        Date lastWriteTime = MsDataTypes.readFileTime(buffer);
        Date changeTime = MsDataTypes.readFileTime(buffer);
        long fileSize = buffer.readUInt64();
        buffer.readRawBytes(8);
        long fileAttributes = buffer.readUInt32();
        long fileNameLen = buffer.readUInt32();
        buffer.readUInt32();
        buffer.readByte();
        buffer.readByte();
        buffer.readRawBytes(24);
        buffer.readUInt16();
        byte[] fileId = buffer.readRawBytes(8);
        String fileName = buffer.readString(StandardCharsets.UTF_16LE, (int)fileNameLen / 2);
        FileInfo fi = new FileInfo(fileName, fileId, fileAttributes, fileSize, 0L);
        return fi;
    }
}

