/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj;

import com.hierynomus.smbj.Config;
import com.hierynomus.smbj.DefaultConfig;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.event.SMBEventBus;
import com.hierynomus.smbj.transport.tcp.DirectTcpTransport;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SMBClient {
    public static final int DEFAULT_PORT = 445;
    private Map<String, Connection> connectionTable = new ConcurrentHashMap<String, Connection>();
    private Config config;
    private SMBEventBus bus;

    public SMBClient() {
        this(new DefaultConfig());
    }

    public SMBClient(Config config) {
        this.config = config;
        this.bus = new SMBEventBus();
    }

    public Connection connect(String hostname) throws IOException {
        return this.getEstablishedOrConnect(hostname, 445);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getEstablishedOrConnect(String hostname, int port) throws IOException {
        SMBClient sMBClient = this;
        synchronized (sMBClient) {
            if (!this.connectionTable.containsKey(hostname)) {
                Connection connection = new Connection(this.config, new DirectTcpTransport(), this.bus);
                connection.connect(hostname, port);
                this.connectionTable.put(hostname, connection);
                return connection;
            }
            return this.connectionTable.get(hostname);
        }
    }
}

