/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.connection;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2MessageFlag;
import com.hierynomus.mssmb2.SMB2MultiCreditPacket;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.messages.SMB2NegotiateRequest;
import com.hierynomus.mssmb2.messages.SMB2NegotiateResponse;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.protocol.commons.socket.SocketClient;
import com.hierynomus.smbj.Config;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.auth.NtlmAuthenticator;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.connection.ConnectionInfo;
import com.hierynomus.smbj.connection.NegotiatedProtocol;
import com.hierynomus.smbj.connection.Request;
import com.hierynomus.smbj.event.SMBEventBus;
import com.hierynomus.smbj.event.SessionLoggedOff;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.transport.PacketReader;
import com.hierynomus.smbj.transport.PacketReceiver;
import com.hierynomus.smbj.transport.TransportException;
import com.hierynomus.smbj.transport.TransportLayer;
import com.hierynomus.smbj.transport.tcp.DirectTcpPacketReader;
import com.hierynomus.spnego.NegTokenInit;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import net.engio.mbassy.listener.Handler;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends SocketClient
implements AutoCloseable,
PacketReceiver<SMB2Packet> {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private ConnectionInfo connectionInfo;
    private Config config;
    private TransportLayer transport;
    private final SMBEventBus bus;
    private PacketReader packetReader;
    private Thread packetReaderThread;
    private final ReentrantLock lock = new ReentrantLock();

    public Connection(Config config, TransportLayer transport, SMBEventBus bus) {
        super(transport.getDefaultPort());
        this.config = config;
        this.transport = transport;
        this.bus = bus;
        bus.subscribe(this);
    }

    @Override
    protected void onConnect() throws IOException {
        super.onConnect();
        this.connectionInfo = new ConnectionInfo(this.config.getClientGuid(), this.getRemoteHostname());
        this.packetReader = new DirectTcpPacketReader(this.getInputStream(), (PacketReceiver)this);
        this.packetReaderThread = new Thread(this.packetReader);
        this.packetReaderThread.start();
        this.transport.init(this.getInputStream(), this.getOutputStream());
        this.negotiateDialect();
        logger.info("Successfully connected to: {}", (Object)this.getRemoteHostname());
    }

    @Override
    public void close() throws Exception {
        this.connectionInfo.getSessionTable().closeRemainingSessions();
        this.packetReader.stop();
        logger.info("Closed connection to {}", (Object)this.getRemoteHostname());
        super.disconnect();
    }

    public Session authenticate(AuthenticationContext authContext) {
        NtlmAuthenticator.Factory factory = new NtlmAuthenticator.Factory();
        try {
            NegTokenInit negTokenInit = new NegTokenInit().read(this.connectionInfo.getGssNegotiateToken());
            if (negTokenInit.getSupportedMechTypes().contains(new ASN1ObjectIdentifier(factory.getName()))) {
                NtlmAuthenticator ntlmAuthenticator = factory.create();
                long sessionId = ntlmAuthenticator.authenticate(this, authContext);
                logger.info("Successfully authenticated {} on {}, session is {}", new Object[]{authContext.getUsername(), this.getRemoteHostname(), sessionId});
                Session session = new Session(sessionId, this, this.bus);
                this.connectionInfo.getSessionTable().registerSession(sessionId, session);
                return session;
            }
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SMB2Packet> Future<T> send(SMB2Packet packet) throws TransportException {
        this.lock.lock();
        try {
            int grantCredits;
            int availableCredits = this.connectionInfo.getSequenceWindow().available();
            if (packet instanceof SMB2MultiCreditPacket) {
                int payloadSize = ((SMB2MultiCreditPacket)packet).getPayloadSize();
                int creditsNeeded = this.creditsNeeded(payloadSize);
                if (availableCredits == 0) {
                    throw new NoSuchElementException("TODO ([MS-SMB2].pdf 3.2.5.1.4 Granting Message Credits)! No credits left.");
                }
                grantCredits = creditsNeeded < availableCredits ? creditsNeeded : (creditsNeeded > 1 && availableCredits > 1 ? availableCredits - 1 : 1);
                long[] messageIds = this.connectionInfo.getSequenceWindow().get(grantCredits);
                ((SMB2MultiCreditPacket)packet).setCreditsAssigned(grantCredits);
                packet.getHeader().setMessageId(messageIds[0]);
                logger.debug("Granted {} credits to {} with message id << {} >>", new Object[]{grantCredits, packet.getHeader().getMessage(), packet.getHeader().getMessageId()});
            } else {
                grantCredits = 1;
                long messageId = this.connectionInfo.getSequenceWindow().get();
                packet.getHeader().setMessageId(messageId);
            }
            packet.getHeader().setCreditRequest(Math.max(512 - availableCredits - grantCredits, grantCredits));
            Request request = new Request(packet.getHeader().getMessageId(), UUID.randomUUID(), packet);
            this.connectionInfo.getOutstandingRequests().registerOutstanding(request);
            this.transport.write(packet);
            Future future = request.getFuture(null);
            return future;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void negotiateDialect() throws TransportException {
        logger.info("Negotiating dialects {} with server {}", this.config.getSupportedDialects(), (Object)this.getRemoteHostname());
        SMB2NegotiateRequest negotiatePacket = new SMB2NegotiateRequest(this.config.getSupportedDialects(), this.connectionInfo.getClientGuid());
        Future send = this.send(negotiatePacket);
        SMB2Packet negotiateResponse = (SMB2Packet)Futures.get(send, TransportException.Wrapper);
        if (!(negotiateResponse instanceof SMB2NegotiateResponse)) {
            throw new IllegalStateException("Expected a SMB2 NEGOTIATE Response, but got: " + negotiateResponse.getHeader().getMessageId());
        }
        SMB2NegotiateResponse resp = (SMB2NegotiateResponse)negotiateResponse;
        this.connectionInfo.negotiated(resp);
        logger.info("Negotiated the following connection settings: {}", (Object)this.connectionInfo);
    }

    private int creditsNeeded(int payloadSize) {
        return Math.abs((payloadSize - 1) / NegotiatedProtocol.SINGLE_CREDIT_PAYLOAD_SIZE) + 1;
    }

    public NegotiatedProtocol getNegotiatedProtocol() {
        return this.connectionInfo.getNegotiatedProtocol();
    }

    @Override
    public void handle(SMB2Packet packet) throws TransportException {
        long messageId = packet.getSequenceNumber();
        if (!this.connectionInfo.getOutstandingRequests().isOutstanding(messageId)) {
            throw new TransportException("Received response with unknown sequence number <<" + messageId + ">>");
        }
        this.connectionInfo.getSequenceWindow().creditsGranted(packet.getHeader().getCreditResponse());
        logger.debug("Server granted us {} credits for message with sequence number << {} >>", (Object)packet.getHeader().getCreditResponse(), (Object)messageId);
        Request request = this.connectionInfo.getOutstandingRequests().getRequestByMessageId(messageId);
        logger.trace("Send/Recv of packet with message id << {} >> took << {} ms >>", (Object)messageId, (Object)(System.currentTimeMillis() - request.getTimestamp().getTime()));
        if (EnumWithValue.EnumUtils.isSet(packet.getHeader().getFlags(), SMB2MessageFlag.SMB2_FLAGS_ASYNC_COMMAND) && packet.getHeader().getStatus() == NtStatus.STATUS_PENDING) {
            request.setAsyncId(packet.getHeader().getAsyncId());
            return;
        }
        if (packet.getHeader().getStatus() == NtStatus.STATUS_NETWORK_SESSION_EXPIRED) {
            return;
        }
        this.connectionInfo.getOutstandingRequests().receivedResponseFor(messageId).getPromise().deliver(packet);
    }

    @Override
    public void handleError(Throwable t) {
        this.connectionInfo.getOutstandingRequests().handleError(t);
    }

    @Handler
    private void sessionLogoff(SessionLoggedOff loggedOff) {
        this.connectionInfo.getSessionTable().sessionClosed(loggedOff.getSessionId());
        logger.debug("Session << {} >> logged off", (Object)loggedOff.getSessionId());
    }
}

