/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.connection;

import com.hierynomus.mssmb2.messages.SMB2NegotiateResponse;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.connection.NegotiatedProtocol;
import com.hierynomus.smbj.connection.OutstandingRequests;
import com.hierynomus.smbj.connection.SequenceWindow;
import com.hierynomus.smbj.connection.SessionTable;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;

public class ConnectionInfo {
    private SessionTable sessionTable = new SessionTable();
    private List<Void> preauthSessionTable;
    private OutstandingRequests outstandingRequests = new OutstandingRequests();
    private SequenceWindow sequenceWindow;
    private byte[] gssNegotiateToken;
    private UUID serverGuid;
    private String serverName;
    private NegotiatedProtocol negotiatedProtocol;
    private UUID clientGuid = UUID.randomUUID();
    private EnumSet<GlobalCapability> clientCapabilities;
    private EnumSet<GlobalCapability> serverCapabilities;
    private int clientSecurityMode;
    private int serverSecurityMode;
    private String server;
    private String preauthIntegrityHashId;
    private byte[] preauthIntegrityHashValue;
    private String cipherId;

    public byte[] getGssNegotiateToken() {
        return this.gssNegotiateToken;
    }

    public ConnectionInfo(UUID clientGuid, String serverName) {
        this.clientGuid = clientGuid;
        this.sequenceWindow = new SequenceWindow();
        this.gssNegotiateToken = new byte[0];
        this.serverName = serverName;
    }

    void negotiated(SMB2NegotiateResponse response) {
        this.gssNegotiateToken = response.getGssToken();
        this.serverGuid = response.getServerGuid();
        this.serverCapabilities = EnumWithValue.EnumUtils.toEnumSet(response.getCapabilities(), GlobalCapability.class);
        this.negotiatedProtocol = new NegotiatedProtocol(response.getDialect(), response.getMaxTransactSize(), response.getMaxReadSize(), response.getMaxWriteSize(), this.serverCapabilities.contains(GlobalCapability.SMB2_GLOBAL_CAP_LARGE_MTU));
        this.serverSecurityMode = response.getSecurityMode();
    }

    SequenceWindow getSequenceWindow() {
        return this.sequenceWindow;
    }

    SessionTable getSessionTable() {
        return this.sessionTable;
    }

    public UUID getClientGuid() {
        return this.clientGuid;
    }

    public boolean isRequireSigning() {
        return (this.serverSecurityMode & 2) > 0;
    }

    public NegotiatedProtocol getNegotiatedProtocol() {
        return this.negotiatedProtocol;
    }

    public UUID getServerGuid() {
        return this.serverGuid;
    }

    public String getServerName() {
        return this.serverName;
    }

    public OutstandingRequests getOutstandingRequests() {
        return this.outstandingRequests;
    }

    public boolean supports(GlobalCapability capability) {
        return this.serverCapabilities.contains(capability);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectionInfo{\n");
        sb.append("  serverGuid=").append(this.serverGuid).append(",\n");
        sb.append("  serverName='").append(this.serverName).append("',\n");
        sb.append("  negotiatedProtocol=").append(this.negotiatedProtocol).append(",\n");
        sb.append("  clientGuid=").append(this.clientGuid).append(",\n");
        sb.append("  clientCapabilities=").append(this.clientCapabilities).append(",\n");
        sb.append("  serverCapabilities=").append(this.serverCapabilities).append(",\n");
        sb.append("  clientSecurityMode=").append(this.clientSecurityMode).append(",\n");
        sb.append("  serverSecurityMode=").append(this.serverSecurityMode).append(",\n");
        sb.append("  server='").append(this.server).append("'\n");
        sb.append('}');
        return sb.toString();
    }

    public static enum GlobalCapability implements EnumWithValue<GlobalCapability>
    {
        SMB2_GLOBAL_CAP_DFS(1L),
        SMB2_GLOBAL_CAP_LEASING(2L),
        SMB2_GLOBAL_CAP_LARGE_MTU(4L),
        SMB2_GLOBAL_CAP_MULTI_CHANNEL(8L),
        SMB2_GLOBAL_CAP_PERSISTENT_HANDLES(16L),
        SMB2_GLOBAL_CAP_DIRECTORY_LEASING(32L),
        SMB2_GLOBAL_CAP_ENCRYPTION(64L);

        private long i;

        private GlobalCapability(long i) {
            this.i = i;
        }

        @Override
        public long getValue() {
            return this.i;
        }
    }
}

