/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.connection;

import com.hierynomus.smbj.session.Session;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SessionTable {
    private static final Logger logger = LoggerFactory.getLogger(SessionTable.class);
    private ReentrantLock lock = new ReentrantLock();
    private Map<Long, Session> lookup = new HashMap<Long, Session>();

    SessionTable() {
    }

    void registerSession(Long id, Session session) {
        this.lock.lock();
        try {
            this.lookup.put(id, session);
        }
        finally {
            this.lock.unlock();
        }
    }

    Session sessionClosed(Long id) {
        this.lock.lock();
        try {
            Session session = this.lookup.remove(id);
            return session;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean isActive(Long id) {
        this.lock.lock();
        try {
            boolean bl = this.lookup.containsKey(id);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeRemainingSessions() {
        this.lock.lock();
        try {
            for (Long id : new HashSet<Long>(this.lookup.keySet())) {
                Session session = this.lookup.get(id);
                try {
                    session.close();
                }
                catch (IOException e) {
                    logger.error("Error closing session", (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

