/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DiskEntry {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected TreeConnect treeConnect;
    protected SMB2FileId fileId;
    protected String fileName;

    public DiskEntry(TreeConnect treeConnect, SMB2FileId fileId, String fileName) {
        this.treeConnect = treeConnect;
        this.fileId = fileId;
        this.fileName = fileName;
    }

    public void close() throws TransportException, SMBApiException {
        this.treeConnect.getHandle().close(this.fileId);
    }

    public SMB2FileId getFileId() {
        return this.fileId;
    }

    public void closeSilently() {
        try {
            this.close();
        }
        catch (Exception e) {
            this.logger.warn("File close failed for {},{},{}", new Object[]{this.fileName, this.treeConnect, this.fileId, e});
        }
    }
}

