/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.messages.SMB2WriteRequest;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.ProgressListener;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.share.RingBuffer;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOutputStream
extends OutputStream {
    private TreeConnect treeConnect;
    private SMB2FileId fileId;
    private Session session;
    private Connection connection;
    private int maxWriteSize;
    private ProgressListener progressListener;
    private boolean isClosed = false;
    private ByteArrayProvider provider;
    private static final Logger logger = LoggerFactory.getLogger(FileOutputStream.class);

    public FileOutputStream(File file, ProgressListener progressListener) {
        this.treeConnect = file.treeConnect;
        this.fileId = file.fileId;
        this.session = this.treeConnect.getSession();
        this.connection = this.session.getConnection();
        this.progressListener = progressListener;
        this.maxWriteSize = this.connection.getNegotiatedProtocol().getMaxWriteSize();
        this.provider = new ByteArrayProvider(this.maxWriteSize);
    }

    @Override
    public void write(int b) throws IOException {
        this.verifyConnectionNotClosed();
        if (this.provider.isBufferFull()) {
            this.flush();
        }
        if (!this.provider.isBufferFull()) {
            this.provider.writeByte(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.verifyConnectionNotClosed();
        if (this.provider.isBufferFull(len)) {
            this.flush();
        }
        if (!this.provider.isBufferFull()) {
            this.provider.writeBytes(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.verifyConnectionNotClosed();
        if (this.provider.isAvailable()) {
            this.sendWriteRequest();
        }
    }

    private void sendWriteRequest() throws TransportException {
        SMB2WriteRequest wreq = new SMB2WriteRequest(this.connection.getNegotiatedProtocol().getDialect(), this.fileId, this.session.getSessionId(), this.treeConnect.getTreeId(), this.provider, this.connection.getNegotiatedProtocol().getMaxWriteSize());
        Future writeFuture = this.connection.send(wreq);
        SMB2WriteResponse wresp = (SMB2WriteResponse)Futures.get(writeFuture, TransportException.Wrapper);
        if (wresp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
            throw new SMBApiException(wresp.getHeader(), "Write failed for " + this);
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressChanged(wresp.getBytesWritten(), this.provider.getOffset());
        }
    }

    @Override
    public void close() throws IOException {
        while (this.provider.isAvailable()) {
            this.sendWriteRequest();
        }
        this.provider.reset();
        this.isClosed = true;
        this.treeConnect = null;
        this.session = null;
        this.connection = null;
        logger.debug("EOF, {} bytes written", (Object)this.provider.getOffset());
    }

    private void verifyConnectionNotClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed");
        }
    }

    private static class ByteArrayProvider
    extends ByteChunkProvider {
        private RingBuffer buf;

        private ByteArrayProvider(int maxWriteSize) {
            this.buf = new RingBuffer(maxWriteSize);
        }

        @Override
        public boolean isAvailable() {
            return this.buf.hasData();
        }

        @Override
        protected int getChunk(byte[] chunk) throws IOException {
            return this.buf.read(chunk);
        }

        @Override
        public int bytesLeft() {
            return this.buf.getUsedSize();
        }

        public void writeBytes(byte[] b, int off, int len) {
            this.buf.write(b, off, len);
        }

        public void writeByte(int b) {
            this.buf.write(b);
        }

        public boolean isBufferFull() {
            return this.buf.isFull();
        }

        public boolean isBufferFull(int len) {
            return this.buf.isFull(len);
        }

        private void reset() {
            this.buf = null;
        }
    }
}

