/*
 * Copyright (C)2016 - SMBJ Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hierynomus.smbj.transport;

import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.spec.SecretKeySpec;
import com.hierynomus.mssmb2.SMB2Packet;

public interface TransportLayer {

    /**
     * Initialize the Transport layer.
     * <p>
     * This is called directly after a connection has been established.
     */
    void init(InputStream in, OutputStream out);

    /**
     * The default port for the specified SMB transport layer.
     *
     * @return the default port
     */
    int getDefaultPort();

    /**
     * Write the packet to the transport.
     *
     * @param packet The packet to write.
     * @return The sequence number of the packet.
     */
    void write(SMB2Packet packet) throws TransportException;

    /**
     * Write the packet to the transport, signed using the given signing key.
     *
     * @param packet         The packet to write.
     * @param signingKeySpec a SecretKeySpec to use while signing.  If null, no signing should be done.
     * @return The sequence number of the packet.
     */
    void writeSigned(SMB2Packet packet, SecretKeySpec signingKeySpec) throws TransportException;
}
