/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.msdtyp.ace;

import com.hierynomus.msdtyp.ace.AceFlags;
import com.hierynomus.msdtyp.ace.AceType;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.smbj.common.SMBBuffer;
import java.util.EnumSet;
import java.util.Set;

public class AceHeader {
    private AceType aceType;
    private Set<AceFlags> aceFlags;
    private int aceSize;

    AceHeader() {
    }

    AceHeader(AceType aceType, Set<AceFlags> aceFlags) {
        this.aceType = aceType;
        this.aceFlags = aceFlags;
    }

    public void writeTo(SMBBuffer buffer) {
        this.writeTo(buffer, this.aceSize);
    }

    void writeTo(SMBBuffer buffer, int aceSize) {
        buffer.putByte((byte)this.aceType.getValue());
        buffer.putByte((byte)EnumWithValue.EnumUtils.toLong(this.aceFlags));
        buffer.putUInt16(aceSize);
    }

    static AceHeader readFrom(SMBBuffer buffer) throws Buffer.BufferException {
        AceType aceType = EnumWithValue.EnumUtils.valueOf(buffer.readByte(), AceType.class, null);
        EnumSet<AceFlags> aceFlags = EnumWithValue.EnumUtils.toEnumSet(buffer.readByte(), AceFlags.class);
        int aceSize = buffer.readUInt16();
        AceHeader header = new AceHeader(aceType, aceFlags);
        header.aceSize = aceSize;
        return header;
    }

    public int getAceSize() {
        return this.aceSize;
    }

    public AceType getAceType() {
        return this.aceType;
    }

    public Set<AceFlags> getAceFlags() {
        return this.aceFlags;
    }

    public String toString() {
        return "AceHeader{aceType=" + this.aceType + ", aceFlags=" + this.aceFlags + ", aceSize=" + this.aceSize + '}';
    }
}

