/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.SecurityInformation;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.FileInformationClass;
import com.hierynomus.msfscc.FileSystemInformationClass;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2Packet;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.messages.SMB2Close;
import com.hierynomus.mssmb2.messages.SMB2CreateRequest;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.mssmb2.messages.SMB2Flush;
import com.hierynomus.mssmb2.messages.SMB2IoctlRequest;
import com.hierynomus.mssmb2.messages.SMB2IoctlResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryRequest;
import com.hierynomus.mssmb2.messages.SMB2QueryDirectoryResponse;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoRequest;
import com.hierynomus.mssmb2.messages.SMB2QueryInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2ReadRequest;
import com.hierynomus.mssmb2.messages.SMB2ReadResponse;
import com.hierynomus.mssmb2.messages.SMB2SetInfoRequest;
import com.hierynomus.mssmb2.messages.SMB2SetInfoResponse;
import com.hierynomus.mssmb2.messages.SMB2WriteRequest;
import com.hierynomus.mssmb2.messages.SMB2WriteResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.connection.NegotiatedProtocol;
import com.hierynomus.smbj.io.ArrayByteChunkProvider;
import com.hierynomus.smbj.io.ByteChunkProvider;
import com.hierynomus.smbj.io.EmptyByteChunkProvider;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Share
implements AutoCloseable {
    private static final SMB2FileId ROOT_ID = new SMB2FileId(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1});
    private static final EnumSet<NtStatus> SUCCESS = EnumSet.of(NtStatus.STATUS_SUCCESS);
    private static final EnumSet<NtStatus> SUCCESS_OR_NO_MORE_FILES = EnumSet.of(NtStatus.STATUS_SUCCESS, NtStatus.STATUS_NO_MORE_FILES);
    private static final EnumSet<NtStatus> SUCCESS_OR_EOF = EnumSet.of(NtStatus.STATUS_SUCCESS, NtStatus.STATUS_END_OF_FILE);
    private final SmbPath smbPath;
    private final TreeConnect treeConnect;
    private final long treeId;
    private final Session session;
    private final SMB2Dialect dialect;
    private final int readBufferSize;
    private final long readTimeout;
    private final int writeBufferSize;
    private final long writeTimeout;
    private final int transactBufferSize;
    private final long transactTimeout;
    private final long sessionId;
    private final AtomicBoolean disconnected = new AtomicBoolean(false);
    private static final EmptyByteChunkProvider EMPTY = new EmptyByteChunkProvider(0L);

    Share(SmbPath smbPath, TreeConnect treeConnect) {
        this.smbPath = smbPath;
        this.treeConnect = treeConnect;
        this.session = treeConnect.getSession();
        Connection connection = treeConnect.getConnection();
        NegotiatedProtocol negotiatedProtocol = connection.getNegotiatedProtocol();
        this.dialect = negotiatedProtocol.getDialect();
        SmbConfig config = connection.getConfig();
        this.readBufferSize = Math.min(config.getReadBufferSize(), negotiatedProtocol.getMaxReadSize());
        this.readTimeout = config.getReadTimeout();
        this.writeBufferSize = Math.min(config.getWriteBufferSize(), negotiatedProtocol.getMaxWriteSize());
        this.writeTimeout = config.getWriteTimeout();
        this.transactBufferSize = Math.min(config.getTransactBufferSize(), negotiatedProtocol.getMaxTransactSize());
        this.transactTimeout = config.getTransactTimeout();
        this.sessionId = this.session.getSessionId();
        this.treeId = treeConnect.getTreeId();
    }

    @Override
    public void close() throws IOException {
        if (!this.disconnected.getAndSet(true)) {
            this.treeConnect.close();
        }
    }

    public boolean isConnected() {
        return !this.disconnected.get();
    }

    public SmbPath getSmbPath() {
        return this.smbPath;
    }

    public TreeConnect getTreeConnect() {
        return this.treeConnect;
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    long getReadTimeout() {
        return this.readTimeout;
    }

    int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    SMB2FileId openFileId(String path, Set<AccessMask> accessMask, Set<FileAttributes> fileAttributes, Set<SMB2ShareAccess> shareAccess, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        return this.createFile(path, accessMask, fileAttributes, shareAccess, createDisposition, createOptions).getFileId();
    }

    SMB2CreateResponse createFile(String path, Set<AccessMask> accessMask, Set<FileAttributes> fileAttributes, Set<SMB2ShareAccess> shareAccess, SMB2CreateDisposition createDisposition, Set<SMB2CreateOptions> createOptions) {
        SMB2CreateRequest cr = new SMB2CreateRequest(this.dialect, this.sessionId, this.treeId, accessMask, fileAttributes, shareAccess, createDisposition, createOptions, path);
        return (SMB2CreateResponse)this.sendReceive(cr, "Create", path, SUCCESS, this.transactTimeout);
    }

    void flush(SMB2FileId fileId) throws SMBApiException {
        SMB2Flush flushReq = new SMB2Flush(this.dialect, fileId);
        this.sendReceive(flushReq, "Flush", fileId, SUCCESS, this.writeTimeout);
    }

    void closeFileId(SMB2FileId fileId) throws SMBApiException {
        SMB2Close closeReq = new SMB2Close(this.dialect, this.sessionId, this.treeId, fileId);
        this.sendReceive(closeReq, "Close", fileId, SUCCESS, this.transactTimeout);
    }

    SMB2QueryInfoResponse queryInfo(SMB2FileId fileId, SMB2QueryInfoRequest.SMB2QueryInfoType infoType, Set<SecurityInformation> securityInfo, FileInformationClass fileInformationClass, FileSystemInformationClass fileSystemInformationClass) {
        SMB2QueryInfoRequest qreq = new SMB2QueryInfoRequest(this.dialect, this.sessionId, this.treeId, fileId, infoType, fileInformationClass, fileSystemInformationClass, null, securityInfo);
        return (SMB2QueryInfoResponse)this.sendReceive(qreq, "QueryInfo", fileId, SUCCESS, this.transactTimeout);
    }

    SMB2SetInfoResponse setInfo(SMB2FileId fileId, SMB2SetInfoRequest.SMB2InfoType infoType, Set<SecurityInformation> securityInfo, FileInformationClass fileInformationClass, byte[] buffer) {
        SMB2SetInfoRequest qreq = new SMB2SetInfoRequest(this.dialect, this.sessionId, this.treeId, infoType, fileId, fileInformationClass, securityInfo, buffer);
        return (SMB2SetInfoResponse)this.sendReceive(qreq, "SetInfo", fileId, SUCCESS, this.transactTimeout);
    }

    SMB2QueryDirectoryResponse queryDirectory(SMB2FileId fileId, Set<SMB2QueryDirectoryRequest.SMB2QueryDirectoryFlags> flags, FileInformationClass informationClass, String searchPattern) {
        SMB2QueryDirectoryRequest qdr = new SMB2QueryDirectoryRequest(this.dialect, this.sessionId, this.treeId, fileId, informationClass, flags, 0L, searchPattern, this.transactBufferSize);
        return (SMB2QueryDirectoryResponse)this.sendReceive(qdr, "Query directory", fileId, SUCCESS_OR_NO_MORE_FILES, this.transactTimeout);
    }

    SMB2WriteResponse write(SMB2FileId fileId, ByteChunkProvider provider) {
        SMB2WriteRequest wreq = new SMB2WriteRequest(this.dialect, fileId, this.sessionId, this.treeId, provider, this.writeBufferSize);
        return (SMB2WriteResponse)this.sendReceive(wreq, "Write", fileId, SUCCESS, this.writeTimeout);
    }

    SMB2ReadResponse read(SMB2FileId fileId, long offset, int length) {
        return this.receive(this.readAsync(fileId, offset, length), "Read", fileId, SUCCESS_OR_EOF, this.readTimeout);
    }

    Future<SMB2ReadResponse> readAsync(SMB2FileId fileId, long offset, int length) {
        SMB2ReadRequest rreq = new SMB2ReadRequest(this.dialect, fileId, this.sessionId, this.treeId, offset, Math.min(length, this.readBufferSize));
        return this.send(rreq);
    }

    public byte[] ioctl(int ctlCode, boolean isFsCtl, byte[] inData, int inOffset, int inLength) {
        return this.ioctl(ROOT_ID, ctlCode, isFsCtl, inData, inOffset, inLength);
    }

    public int ioctl(int ctlCode, boolean isFsCtl, byte[] inData, int inOffset, int inLength, byte[] outData, int outOffset, int outLength) {
        return this.ioctl(ROOT_ID, ctlCode, isFsCtl, inData, inOffset, inLength, outData, outOffset, outLength);
    }

    byte[] ioctl(SMB2FileId fileId, int ctlCode, boolean isFsCtl, byte[] inData, int inOffset, int inLength) {
        return this.ioctl(fileId, ctlCode, isFsCtl, inData, inOffset, inLength, -1);
    }

    byte[] ioctl(SMB2FileId fileId, int ctlCode, boolean isFsCtl, byte[] inData, int inOffset, int inLength, int maxOutputResponse) {
        SMB2IoctlResponse response = this.ioctl(fileId, ctlCode, isFsCtl, new ArrayByteChunkProvider(inData, inOffset, inLength, 0L), maxOutputResponse);
        return response.getOutputBuffer();
    }

    int ioctl(SMB2FileId fileId, int ctlCode, boolean isFsCtl, byte[] inData, int inOffset, int inLength, byte[] outData, int outOffset, int outLength) {
        SMB2IoctlResponse response = this.ioctl(fileId, ctlCode, isFsCtl, new ArrayByteChunkProvider(inData, inOffset, inLength, 0L), outLength);
        int length = 0;
        if (outData != null) {
            byte[] outputBuffer = response.getOutputBuffer();
            length = Math.min(outLength, outputBuffer.length);
            System.arraycopy(outputBuffer, 0, outData, outOffset, length);
        }
        return length;
    }

    private SMB2IoctlResponse ioctl(SMB2FileId fileId, int ctlCode, boolean isFsCtl, ByteChunkProvider inputData, int maxOutputResponse) {
        Future<SMB2IoctlResponse> fut = this.ioctlAsync(fileId, ctlCode, isFsCtl, inputData, maxOutputResponse);
        return this.receive(fut, "IOCTL", fileId, SUCCESS, this.transactTimeout);
    }

    Future<SMB2IoctlResponse> ioctlAsync(int ctlCode, boolean isFsCtl, ByteChunkProvider inputData) {
        return this.ioctlAsync(ROOT_ID, ctlCode, isFsCtl, inputData, -1);
    }

    private Future<SMB2IoctlResponse> ioctlAsync(SMB2FileId fileId, int ctlCode, boolean isFsCtl, ByteChunkProvider inputData, int maxOutputResponse) {
        int maxResponse;
        ByteChunkProvider inData;
        ByteChunkProvider byteChunkProvider = inData = inputData == null ? EMPTY : inputData;
        if (inData.bytesLeft() > this.transactBufferSize) {
            throw new SMBRuntimeException("Input data size exceeds maximum allowed by server: " + inData.bytesLeft() + " > " + this.transactBufferSize);
        }
        if (maxOutputResponse < 0) {
            maxResponse = this.transactBufferSize;
        } else {
            if (maxOutputResponse > this.transactBufferSize) {
                throw new SMBRuntimeException("Output data size exceeds maximum allowed by server: " + maxOutputResponse + " > " + this.transactBufferSize);
            }
            maxResponse = maxOutputResponse;
        }
        SMB2IoctlRequest ioreq = new SMB2IoctlRequest(this.dialect, this.sessionId, this.treeId, ctlCode, fileId, inData, isFsCtl, maxResponse);
        return this.send(ioreq);
    }

    private <T extends SMB2Packet> T sendReceive(SMB2Packet request, String name, Object target, Set<NtStatus> successResponses, long timeout) {
        Future<T> fut = this.send(request);
        return this.receive(fut, name, target, successResponses, timeout);
    }

    private <T extends SMB2Packet> Future<T> send(SMB2Packet request) {
        try {
            return this.session.send(request);
        }
        catch (TransportException e) {
            throw new SMBRuntimeException(e);
        }
    }

    <T extends SMB2Packet> T receive(Future<T> fut, String name, Object target, Set<NtStatus> successResponses, long timeout) {
        T resp = this.receive(fut, timeout);
        NtStatus status = ((SMB2Packet)resp).getHeader().getStatus();
        if (!successResponses.contains(status)) {
            throw new SMBApiException(((SMB2Packet)resp).getHeader(), name + " failed for " + target);
        }
        return resp;
    }

    <T extends SMB2Packet> T receive(Future<T> fut, long timeout) {
        SMB2Packet resp;
        try {
            resp = timeout > 0L ? (SMB2Packet)Futures.get(fut, timeout, TimeUnit.MILLISECONDS, TransportException.Wrapper) : (SMB2Packet)Futures.get(fut, TransportException.Wrapper);
        }
        catch (TransportException e) {
            throw new SMBRuntimeException(e);
        }
        return (T)resp;
    }
}

