/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.transport.tcp;

import com.hierynomus.protocol.Packet;
import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.smbj.transport.PacketFactory;
import com.hierynomus.smbj.transport.PacketReader;
import com.hierynomus.smbj.transport.PacketReceiver;
import com.hierynomus.smbj.transport.TransportException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DirectTcpPacketReader<P extends Packet<P, ?>>
extends PacketReader<P> {
    private final PacketFactory<P> packetFactory;

    public DirectTcpPacketReader(String host, InputStream in, PacketFactory<P> packetFactory, PacketReceiver<P> handler) {
        super(host, in, handler);
        this.packetFactory = packetFactory;
    }

    private P _readSMB2Packet(int packetLength) throws IOException, Buffer.BufferException {
        byte[] buf = new byte[packetLength];
        int read = 0;
        for (int count = 0; count < packetLength && (read = this.in.read(buf, count, packetLength - count)) != -1; count += read) {
        }
        if (read == -1) {
            throw new TransportException(new EOFException("EOF while reading packet"));
        }
        return this.packetFactory.read(buf);
    }

    @Override
    protected P doRead() throws TransportException {
        try {
            int smb2PacketLength = this._readTcpHeader();
            return this._readSMB2Packet(smb2PacketLength);
        }
        catch (TransportException e) {
            throw e;
        }
        catch (Buffer.BufferException | IOException e) {
            throw new TransportException(e);
        }
    }

    private int _readTcpHeader() throws IOException, Buffer.BufferException {
        byte[] tcpHeader = new byte[4];
        this.readFully(tcpHeader);
        Buffer.PlainBuffer plainBuffer = new Buffer.PlainBuffer(tcpHeader, Endian.BE);
        plainBuffer.readByte();
        int packetLength = plainBuffer.readUInt24();
        return packetLength;
    }

    private void readFully(byte[] buffer) throws IOException {
        int toRead = buffer.length;
        int offset = 0;
        while (toRead > 0) {
            int bytesRead = this.in.read(buffer, offset, toRead);
            if (bytesRead == -1) {
                throw new TransportException(new EOFException("EOF while reading packet"));
            }
            toRead -= bytesRead;
            offset += bytesRead;
        }
    }
}

