/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.spnego;

import com.hierynomus.protocol.commons.buffer.Buffer;
import com.hierynomus.protocol.commons.buffer.Endian;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.spnego.ObjectIdentifiers;
import com.hierynomus.spnego.SpnegoException;
import com.hierynomus.spnego.SpnegoToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class NegTokenInit
extends SpnegoToken {
    private static final String ADS_IGNORE_PRINCIPAL = "not_defined_in_RFC4178@please_ignore";
    private List<ASN1ObjectIdentifier> mechTypes = new ArrayList<ASN1ObjectIdentifier>();
    private byte[] mechToken;

    public NegTokenInit() {
        super(0, "NegTokenInit");
    }

    public void write(Buffer<?> buffer) {
        try {
            ASN1EncodableVector negTokenInit = new ASN1EncodableVector();
            this.addMechTypeList(negTokenInit);
            this.addMechToken(negTokenInit);
            this.writeGss(buffer, negTokenInit);
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    public NegTokenInit read(byte[] bytes) throws IOException {
        return this.read(new Buffer.PlainBuffer(bytes, Endian.LE));
    }

    private NegTokenInit read(Buffer<?> buffer) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream(buffer.asInputStream());){
            ASN1Primitive applicationSpecific = is.readObject();
            if (!(applicationSpecific instanceof BERApplicationSpecific) && !(applicationSpecific instanceof DERApplicationSpecific)) {
                throw new SpnegoException("Incorrect GSS-API ASN.1 token received, expected to find an [APPLICATION 0], not: " + applicationSpecific);
            }
            ASN1Sequence implicitSequence = (ASN1Sequence)((ASN1ApplicationSpecific)applicationSpecific).getObject(16);
            ASN1Encodable spnegoOid = implicitSequence.getObjectAt(0);
            if (!(spnegoOid instanceof ASN1ObjectIdentifier)) {
                throw new SpnegoException("Expected to find the SPNEGO OID (" + ObjectIdentifiers.SPNEGO + "), not: " + spnegoOid);
            }
            this.parseSpnegoToken(implicitSequence.getObjectAt(1));
        }
        catch (SpnegoException e) {
            throw new SMBRuntimeException(e);
        }
        return this;
    }

    @Override
    protected void parseTagged(ASN1TaggedObject asn1TaggedObject) throws SpnegoException {
        if (asn1TaggedObject.getObject().toString().contains(ADS_IGNORE_PRINCIPAL)) {
            return;
        }
        switch (asn1TaggedObject.getTagNo()) {
            case 0: {
                this.readMechTypeList(asn1TaggedObject.getObject());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.readMechToken(asn1TaggedObject.getObject());
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new SpnegoException("Unknown Object Tag " + asn1TaggedObject.getTagNo() + " encountered.");
            }
        }
    }

    private void readMechToken(ASN1Primitive mechToken) throws SpnegoException {
        if (!(mechToken instanceof ASN1OctetString)) {
            throw new SpnegoException("Expected the MechToken (OCTET_STRING) contents, not: " + mechToken);
        }
        this.mechToken = ((ASN1OctetString)mechToken).getOctets();
    }

    private void readMechTypeList(ASN1Primitive sequence) throws SpnegoException {
        if (!(sequence instanceof ASN1Sequence)) {
            throw new SpnegoException("Expected the MechTypeList (SEQUENCE) contents, not: " + sequence);
        }
        Enumeration mechTypeElems = ((ASN1Sequence)sequence).getObjects();
        while (mechTypeElems.hasMoreElements()) {
            ASN1Encodable mechType = (ASN1Encodable)mechTypeElems.nextElement();
            if (!(mechType instanceof ASN1ObjectIdentifier)) {
                throw new SpnegoException("Expected a MechType (OBJECT IDENTIFIER) as contents of the MechTypeList, not: " + mechType);
            }
            this.mechTypes.add((ASN1ObjectIdentifier)mechType);
        }
    }

    private void addMechToken(ASN1EncodableVector negTokenInit) {
        if (this.mechToken != null && this.mechToken.length > 0) {
            DERTaggedObject token = new DERTaggedObject(true, 2, (ASN1Encodable)new DEROctetString(this.mechToken));
            negTokenInit.add((ASN1Encodable)token);
        }
    }

    private void addMechTypeList(ASN1EncodableVector negTokenInit) {
        if (this.mechTypes.size() > 0) {
            ASN1EncodableVector supportedMechVector = new ASN1EncodableVector();
            for (ASN1ObjectIdentifier mechType : this.mechTypes) {
                supportedMechVector.add((ASN1Encodable)mechType);
            }
            DERTaggedObject asn1Encodables1 = new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(supportedMechVector));
            negTokenInit.add((ASN1Encodable)asn1Encodables1);
        }
    }

    public void addSupportedMech(ASN1ObjectIdentifier oid) {
        this.mechTypes.add(oid);
    }

    public void setMechToken(byte[] mechToken) {
        this.mechToken = mechToken;
    }

    public List<ASN1ObjectIdentifier> getSupportedMechTypes() {
        return this.mechTypes;
    }
}

