/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.span;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.graphics.AndroidPath_androidKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.bar.data.SpanData;
import com.himanshoe.charty.bar.internal.span.SpanDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a<\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0000\u00a8\u0006\u000e"}, d2={"drawSpans", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "params", "Lcom/himanshoe/charty/bar/internal/span/SpanDrawParams;", "drawRoundedSpan", "brush", "Landroidx/compose/ui/graphics/Brush;", "x", "", "y", "width", "height", "cornerRadius", "charty_release"})
@SourceDebugExtension(value={"SMAP\nSpanChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpanChartDrawer.kt\ncom/himanshoe/charty/bar/internal/span/SpanChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n*L\n1#1,88:1\n71#2,5:89\n33#3:94\n33#3:98\n33#3:102\n33#3:106\n53#4,3:95\n53#4,3:99\n53#4,3:103\n53#4,3:107\n*S KotlinDebug\n*F\n+ 1 SpanChartDrawer.kt\ncom/himanshoe/charty/bar/internal/span/SpanChartDrawerKt\n*L\n14#1:89,5\n78#1:94\n79#1:98\n80#1:102\n81#1:106\n78#1:95,3\n79#1:99,3\n80#1:103,3\n81#1:107,3\n*E\n"})
public final class SpanChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawSpans(@NotNull DrawScope $this$drawSpans, @NotNull SpanDrawParams params) {
        Intrinsics.checkNotNullParameter((Object)$this$drawSpans, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        float range = params.getMaxValue() - params.getMinValue();
        List<SpanData> $this$fastForEachIndexed$iv = params.getDataList();
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void span;
            SpanData item$iv;
            SpanData spanData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            ChartyColor chartyColor = span.getColor();
            if (chartyColor == null) {
                chartyColor = params.getColors();
            }
            ChartyColor spanChartyColor = chartyColor;
            float barHeight = params.getChartContext().getHeight() / (float)params.getDataList().size();
            float barY = params.getChartContext().getTop() + barHeight * (float)index;
            float barThickness = barHeight * params.getBarConfig().getBarWidthFraction();
            float centeredBarY = barY + (barHeight - barThickness) / (float)2;
            float startNormalized = (span.getStartValue() - params.getMinValue()) / range;
            float endNormalized = (span.getEndValue() - params.getMinValue()) / range;
            float startX = params.getChartContext().getLeft() + params.getAxisOffset() + startNormalized * (params.getChartContext().getWidth() - params.getAxisOffset());
            float endX = params.getChartContext().getLeft() + params.getAxisOffset() + endNormalized * (params.getChartContext().getWidth() - params.getAxisOffset());
            float fullSpanWidth = endX - startX;
            float animatedSpanWidth = fullSpanWidth * params.getAnimationProgress();
            if (params.getOnSpanClick() != null && animatedSpanWidth > 0.0f) {
                params.getOnSpanBoundCalculated().invoke((Object)TuplesKt.to((Object)new Rect(startX, centeredBarY, startX + animatedSpanWidth, centeredBarY + barThickness), (Object)span));
            }
            Brush brush = Brush.Companion.horizontalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, spanChartyColor.getValue(), (float)startX, (float)endX, (int)0, (int)8, null);
            SpanChartDrawerKt.drawRoundedSpan($this$drawSpans, brush, startX, centeredBarY, animatedSpanWidth, barThickness, params.getBarConfig().getCornerRadius().getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawRoundedSpan(@NotNull DrawScope $this$drawRoundedSpan, @NotNull Brush brush, float x, float y, float width, float height, float cornerRadius) {
        void x$iv;
        void x$iv2;
        void x$iv3;
        void x$iv4;
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$drawRoundedSpan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        Path $this$drawRoundedSpan_u24lambda_u240 = path = AndroidPath_androidKt.Path();
        boolean bl = false;
        float f = x + width;
        float f2 = y + height;
        float f3 = cornerRadius;
        float y$iv = cornerRadius;
        boolean $i$f$CornerRadius22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)x$iv4);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv);
        long l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        float $i$f$CornerRadius22 = cornerRadius;
        float y$iv2 = cornerRadius;
        boolean $i$f$CornerRadius32 = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv3);
        long v2$iv$iv2 = Float.floatToRawIntBits(y$iv2);
        long l2 = CornerRadius.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
        float $i$f$CornerRadius32 = cornerRadius;
        float y$iv3 = cornerRadius;
        boolean $i$f$CornerRadius42 = false;
        boolean $i$f$packFloats3 = false;
        long v1$iv$iv3 = Float.floatToRawIntBits((float)x$iv2);
        long v2$iv$iv3 = Float.floatToRawIntBits(y$iv3);
        long l3 = CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv3 & 0xFFFFFFFFL));
        float $i$f$CornerRadius42 = cornerRadius;
        float y$iv4 = cornerRadius;
        boolean $i$f$CornerRadius = false;
        boolean $i$f$packFloats4 = false;
        long v1$iv$iv4 = Float.floatToRawIntBits((float)x$iv);
        long v2$iv$iv4 = Float.floatToRawIntBits(y$iv4);
        long l4 = CornerRadius.constructor-impl((long)(v1$iv$iv4 << 32 | v2$iv$iv4 & 0xFFFFFFFFL));
        Path.addRoundRect$default((Path)$this$drawRoundedSpan_u24lambda_u240, (RoundRect)new RoundRect(x, y, f, f2, l, l2, l4, l3, null), null, (int)2, null);
        Path path2 = path;
        DrawScope.drawPath-GBMwjPU$default((DrawScope)$this$drawRoundedSpan, (Path)path2, (Brush)brush, (float)0.0f, null, null, (int)0, (int)60, null);
    }
}

