/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.block.internal;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.RoundRect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.block.config.BlockBarChartConfig;
import com.himanshoe.charty.block.data.BlockData;
import com.himanshoe.charty.color.ChartyColor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aD\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"drawBlockBar", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "blocks", "", "Lcom/himanshoe/charty/block/data/BlockData;", "config", "Lcom/himanshoe/charty/block/config/BlockBarChartConfig;", "drawSegment", "startX", "", "width", "height", "radius", "roundStart", "", "roundEnd", "color", "Lcom/himanshoe/charty/color/ChartyColor;", "charty_release"})
@SourceDebugExtension(value={"SMAP\nBlockBarHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockBarHelpers.kt\ncom/himanshoe/charty/block/internal/BlockBarHelpersKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/Size\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 6 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 7 CornerRadius.kt\nandroidx/compose/ui/geometry/CornerRadiusKt\n+ 8 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 9 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n*L\n1#1,116:1\n1#2:117\n57#3:118\n61#3:121\n60#4:119\n70#4:122\n53#4,3:130\n53#4,3:134\n53#4,3:138\n53#4,3:142\n53#4,3:146\n53#4,3:150\n22#5:120\n22#5:123\n71#6,5:124\n33#7:129\n33#7:133\n33#7:145\n33#7:149\n30#8:137\n33#9:141\n*S KotlinDebug\n*F\n+ 1 BlockBarHelpers.kt\ncom/himanshoe/charty/block/internal/BlockBarHelpersKt\n*L\n27#1:118\n28#1:121\n27#1:119\n28#1:122\n78#1:130,3\n79#1:134,3\n94#1:138,3\n95#1:142,3\n103#1:146,3\n111#1:150,3\n27#1:120\n28#1:123\n37#1:124,5\n78#1:129\n79#1:133\n103#1:145\n111#1:149\n94#1:137\n95#1:141\n*E\n"})
public final class BlockBarHelpersKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawBlockBar(@NotNull DrawScope $this$drawBlockBar, @NotNull List<BlockData> blocks, @NotNull BlockBarChartConfig config) {
        Intrinsics.checkNotNullParameter((Object)$this$drawBlockBar, (String)"<this>");
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (blocks.isEmpty()) {
            return;
        }
        Iterable iterable = blocks;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            BlockData blockData = (BlockData)t;
            double d2 = d;
            boolean bl = false;
            double d3 = it.getValue();
            d = d2 + d3;
        }
        float totalValue = (float)d;
        if (totalValue <= 0.0f) {
            return;
        }
        long arg0$iv = $this$drawBlockBar.getSize-NH-jbRc();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float canvasWidth = Float.intBitsToFloat(bits$iv$iv$iv);
        long arg0$iv2 = $this$drawBlockBar.getSize-NH-jbRc();
        boolean bl2 = false;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float canvasHeight = Float.intBitsToFloat(bits$iv$iv$iv2);
        float gapPx = $this$drawBlockBar.toPx-0680j_4(config.getGapBetweenBlocks-D9Ej5fM());
        float radiusPx = config.getCornerRadius().getValue();
        float totalGaps = gapPx * (float)RangesKt.coerceAtLeast((int)(blocks.size() - 1), (int)0);
        float usableWidth = RangesKt.coerceAtLeast((float)(canvasWidth - totalGaps), (float)0.0f);
        float cursorX = 0.0f;
        List<BlockData> $this$fastForEachIndexed$iv = blocks;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void block;
            BlockData item$iv;
            BlockData blockData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl3 = false;
            float blockWidth = usableWidth * (block.getValue() / totalValue);
            boolean isFirstBlock = index == 0;
            boolean isLastBlock = index == CollectionsKt.getLastIndex(blocks);
            BlockBarHelpersKt.drawSegment($this$drawBlockBar, cursorX, blockWidth, canvasHeight, radiusPx, isFirstBlock, isLastBlock, block.getColor());
            cursorX += blockWidth + gapPx;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void drawSegment(DrawScope $this$drawSegment, float startX, float width, float height, float radius, boolean roundStart, boolean roundEnd, ChartyColor color) {
        boolean $i$f$CornerRadius;
        float y$iv;
        float x$iv;
        void width$iv;
        void x$iv2;
        long l;
        long leftCornerRadius;
        long l2;
        if (width <= 0.0f) {
            return;
        }
        if (roundStart) {
            float x$iv3;
            float y$iv2 = x$iv3 = radius;
            boolean $i$f$CornerRadius2 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(x$iv3);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv2);
            l2 = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        } else {
            l2 = leftCornerRadius = CornerRadius.Companion.getZero-kKHJgLs();
        }
        if (roundEnd) {
            float x$iv4;
            float y$iv3 = x$iv4 = radius;
            boolean $i$f$CornerRadius3 = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(x$iv4);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv3);
            l = CornerRadius.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        } else {
            l = CornerRadius.Companion.getZero-kKHJgLs();
        }
        long rightCornerRadius = l;
        float y$iv3 = startX + width;
        RoundRect segmentRect = new RoundRect(startX, 0.0f, y$iv3, height, leftCornerRadius, rightCornerRadius, rightCornerRadius, leftCornerRadius, null);
        List<Color> colors = color.getValue();
        float v1$iv$iv = segmentRect.getLeft();
        float y$iv4 = segmentRect.getTop();
        boolean $i$f$Offset22 = false;
        boolean $i$f$packFloats = false;
        long v1$iv$iv2 = Float.floatToRawIntBits((float)x$iv2);
        long v2$iv$iv = Float.floatToRawIntBits(y$iv4);
        long topLeft = Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv & 0xFFFFFFFFL));
        float $i$f$Offset22 = segmentRect.getWidth();
        float height$iv = segmentRect.getHeight();
        boolean $i$f$Size = false;
        boolean $i$f$packFloats2 = false;
        long v1$iv$iv3 = Float.floatToRawIntBits((float)width$iv);
        long v2$iv$iv2 = Float.floatToRawIntBits(height$iv);
        long segmentSize = Size.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
        if (colors.size() == 1) {
            y$iv = x$iv = radius;
            $i$f$CornerRadius = false;
            $i$f$packFloats2 = false;
            v1$iv$iv3 = Float.floatToRawIntBits(x$iv);
            v2$iv$iv2 = Float.floatToRawIntBits(y$iv);
            DrawScope.drawRoundRect-u-Aw5IA$default((DrawScope)$this$drawSegment, (long)((Color)CollectionsKt.first(colors)).unbox-impl(), (long)topLeft, (long)segmentSize, (long)CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv2 & 0xFFFFFFFFL)), null, (float)0.0f, null, (int)0, (int)240, null);
        } else {
            y$iv = x$iv = radius;
            $i$f$CornerRadius = false;
            $i$f$packFloats2 = false;
            v1$iv$iv3 = Float.floatToRawIntBits(x$iv);
            v2$iv$iv2 = Float.floatToRawIntBits(y$iv);
            DrawScope.drawRoundRect-ZuiqVtQ$default((DrawScope)$this$drawSegment, (Brush)Brush.Companion.horizontalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, colors, (float)0.0f, (float)0.0f, (int)0, (int)14, null), (long)topLeft, (long)segmentSize, (long)CornerRadius.constructor-impl((long)(v1$iv$iv3 << 32 | v2$iv$iv2 & 0xFFFFFFFFL)), (float)0.0f, null, null, (int)0, (int)240, null);
        }
    }
}

