/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.candlestick;

import androidx.compose.animation.core.Animatable;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.candlestick.config.CandlestickChartConfig;
import com.himanshoe.charty.candlestick.data.CandleData;
import com.himanshoe.charty.candlestick.ext.CandlestickChartExtKt;
import com.himanshoe.charty.candlestick.internal.CandlestickChartDrawerKt;
import com.himanshoe.charty.candlestick.internal.CandlestickChartHelpersKt;
import com.himanshoe.charty.candlestick.internal.CandlestickDrawParams;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.ChartOrientation;
import com.himanshoe.charty.common.ChartScaffoldKt;
import com.himanshoe.charty.common.animation.AnimationHelperKt;
import com.himanshoe.charty.common.axis.AxisConfig;
import com.himanshoe.charty.common.axis.LabelRotation;
import com.himanshoe.charty.common.config.ChartScaffoldConfig;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aS\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"CandlestickChart", "", "data", "Lkotlin/Function0;", "", "Lcom/himanshoe/charty/candlestick/data/CandleData;", "modifier", "Landroidx/compose/ui/Modifier;", "bullishColor", "Lcom/himanshoe/charty/color/ChartyColor;", "bearishColor", "candlestickConfig", "Lcom/himanshoe/charty/candlestick/config/CandlestickChartConfig;", "scaffoldConfig", "Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/Modifier;Lcom/himanshoe/charty/color/ChartyColor;Lcom/himanshoe/charty/color/ChartyColor;Lcom/himanshoe/charty/candlestick/config/CandlestickChartConfig;Lcom/himanshoe/charty/common/config/ChartScaffoldConfig;Landroidx/compose/runtime/Composer;II)V", "charty_release"})
@SourceDebugExtension(value={"SMAP\nCandlestickChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CandlestickChart.kt\ncom/himanshoe/charty/candlestick/CandlestickChartKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,147:1\n1282#2,6:148\n1282#2,6:155\n1282#2,6:161\n1282#2,6:167\n1#3:154\n71#4,5:173\n*S KotlinDebug\n*F\n+ 1 CandlestickChart.kt\ncom/himanshoe/charty/candlestick/CandlestickChartKt\n*L\n66#1:148,6\n68#1:155,6\n71#1:161,6\n88#1:167,6\n89#1:173,5\n*E\n"})
public final class CandlestickChartKt {
    /*
     * WARNING - void declaration
     */
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void CandlestickChart(@NotNull Function0<? extends List<CandleData>> data, @Nullable Modifier modifier, @Nullable ChartyColor bullishColor, @Nullable ChartyColor bearishColor, @Nullable CandlestickChartConfig candlestickConfig, @Nullable ChartScaffoldConfig scaffoldConfig, @Nullable Composer $composer, int $changed, int n) {
        block32: {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            $composer = $composer.startRestartGroup(233011551);
            ComposerKt.sourceInformation((Composer)$composer, (String)"C(CandlestickChart)N(data,modifier,bullishColor,bearishColor,candlestickConfig,scaffoldConfig)65@3476L25,67@3613L93,70@3725L81,74@3836L51,87@4205L2657,76@3893L2969:CandlestickChart.kt#6ybok9");
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance(data) ? 4 : 2;
            }
            if ((n & 2) != 0) {
                $dirty |= 0x30;
            } else if (($changed & 0x30) == 0) {
                $dirty |= $composer.changed((Object)modifier) ? 32 : 16;
            }
            if (($changed & 0x180) == 0) {
                $dirty |= (n & 4) == 0 && $composer.changed((Object)bullishColor) ? 256 : 128;
            }
            if (($changed & 0xC00) == 0) {
                $dirty |= (n & 8) == 0 && $composer.changed((Object)bearishColor) ? 2048 : 1024;
            }
            if (($changed & 0x6000) == 0) {
                $dirty |= (n & 0x10) == 0 && (($changed & 0x8000) == 0 ? $composer.changed((Object)candlestickConfig) : $composer.changedInstance((Object)candlestickConfig)) ? 16384 : 8192;
            }
            if (($changed & 0x30000) == 0) {
                $dirty |= (n & 0x20) == 0 && $composer.changed((Object)scaffoldConfig) ? 131072 : 65536;
            }
            if ($composer.shouldExecute(($dirty & 0x12493) != 74898, $dirty & 1)) {
                Object object;
                void $this$cache$iv;
                List<String> list;
                void $this$cache$iv2;
                Object object2;
                void $this$cache$iv3;
                Object object3;
                void $this$cache$iv4;
                $composer.startDefaults();
                if (($changed & 1) == 0 || $composer.getDefaultsInvalid()) {
                    if ((n & 2) != 0) {
                        modifier = (Modifier)Modifier.Companion;
                    }
                    if ((n & 4) != 0) {
                        bullishColor = new ChartyColor.Solid(ColorKt.Color((long)4283215696L), null);
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        bearishColor = new ChartyColor.Solid(ColorKt.Color((long)4294198070L), null);
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        candlestickConfig = new CandlestickChartConfig(0.0f, 0.0f, 0.0f, false, null, null, 63, null);
                        $dirty &= 0xFFFF1FFF;
                    }
                    if ((n & 0x20) != 0) {
                        scaffoldConfig = new ChartScaffoldConfig(false, false, false, 0L, null, 0L, 0.0f, 0.0f, null, 511, null);
                        $dirty &= 0xFFF8FFFF;
                    }
                } else {
                    $composer.skipToGroupEnd();
                    if ((n & 4) != 0) {
                        $dirty &= 0xFFFFFC7F;
                    }
                    if ((n & 8) != 0) {
                        $dirty &= 0xFFFFE3FF;
                    }
                    if ((n & 0x10) != 0) {
                        $dirty &= 0xFFFF1FFF;
                    }
                    if ((n & 0x20) != 0) {
                        $dirty &= 0xFFF8FFFF;
                    }
                }
                $composer.endDefaults();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)233011551, (int)$dirty, (int)-1, (String)"com.himanshoe.charty.candlestick.CandlestickChart (CandlestickChart.kt:64)");
                }
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)585816088, (String)"CC(remember):CandlestickChart.kt#9igjgp");
                Composer composer = $composer;
                boolean invalid$iv22 = ($dirty & 0xE) == 4;
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv4.rememberedValue();
                boolean bl = false;
                if (invalid$iv22 || it$iv == Composer.Companion.getEmpty()) {
                    boolean bl2 = false;
                    List value$iv = (List)data.invoke();
                    $this$cache$iv4.updateRememberedValue((Object)value$iv);
                    object3 = value$iv;
                } else {
                    object3 = it$iv;
                }
                List list2 = (List)object3;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                List dataList = list2;
                if (!(!((Collection)dataList).isEmpty())) {
                    boolean $i$a$-require-CandlestickChartKt$CandlestickChart$22 = false;
                    String $i$a$-require-CandlestickChartKt$CandlestickChart$22 = "Candlestick chart data cannot be empty";
                    throw new IllegalArgumentException($i$a$-require-CandlestickChartKt$CandlestickChart$22.toString());
                }
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)585820540, (String)"CC(remember):CandlestickChart.kt#9igjgp");
                Composer invalid$iv22 = $composer;
                boolean invalid$iv = $composer.changed((Object)dataList);
                boolean $i$f$cache22 = false;
                Object it$iv2 = $this$cache$iv3.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv || it$iv2 == Composer.Companion.getEmpty()) {
                    boolean bl3 = false;
                    Pair value$iv = TuplesKt.to((Object)Float.valueOf(CandlestickChartExtKt.calculateMinValue(dataList)), (Object)Float.valueOf(CandlestickChartExtKt.calculateMaxValue(dataList)));
                    $this$cache$iv3.updateRememberedValue((Object)value$iv);
                    object2 = value$iv;
                } else {
                    object2 = it$iv2;
                }
                Pair $i$a$-require-CandlestickChartKt$CandlestickChart$22 = (Pair)object2;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                list2 = $i$a$-require-CandlestickChartKt$CandlestickChart$22;
                float minValue = ((Number)list2.component1()).floatValue();
                float maxValue = ((Number)list2.component2()).floatValue();
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)585824112, (String)"CC(remember):CandlestickChart.kt#9igjgp");
                it$iv2 = $composer;
                boolean invalid$iv32 = $composer.changed((Object)dataList);
                boolean $i$f$cache3 = false;
                List<String> it$iv3 = $this$cache$iv2.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv32 || it$iv3 == Composer.Companion.getEmpty()) {
                    boolean bl4 = false;
                    List<String> value$iv = CandlestickChartHelpersKt.calculateOptimizedLabels(CandlestickChartExtKt.getLabels(dataList));
                    $this$cache$iv2.updateRememberedValue(value$iv);
                    list = value$iv;
                } else {
                    list = it$iv3;
                }
                List $i$f$cache22 = list;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                List xLabels = $i$f$cache22;
                Animatable<Float, ?> animationProgress = AnimationHelperKt.rememberChartAnimation(candlestickConfig.getAnimation(), null, 0.0f, $composer, 0, 6);
                Modifier modifier2 = modifier;
                List list3 = xLabels;
                AxisConfig axisConfig = new AxisConfig(minValue, maxValue, 6, null, false, 8, null);
                ChartScaffoldConfig chartScaffoldConfig = scaffoldConfig;
                ChartOrientation chartOrientation = null;
                LabelRotation labelRotation = null;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer, (int)585842048, (String)"CC(remember):CandlestickChart.kt#9igjgp");
                Composer invalid$iv32 = $composer;
                boolean invalid$iv4 = $composer.changedInstance((Object)dataList) | (($dirty & 0xE000 ^ 0x6000) > 16384 && $composer.changedInstance((Object)candlestickConfig) || ($dirty & 0x6000) == 16384) | (($dirty & 0x380 ^ 0x180) > 256 && $composer.changed((Object)bullishColor) || ($dirty & 0x180) == 256) | (($dirty & 0x1C00 ^ 0xC00) > 2048 && $composer.changed((Object)bearishColor) || ($dirty & 0xC00) == 2048) | $composer.changedInstance(animationProgress);
                boolean $i$f$cache4 = false;
                Object it$iv4 = $this$cache$iv.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv4 || it$iv4 == Composer.Companion.getEmpty()) {
                    LabelRotation labelRotation2 = labelRotation;
                    ChartOrientation chartOrientation2 = chartOrientation;
                    ChartScaffoldConfig chartScaffoldConfig2 = chartScaffoldConfig;
                    AxisConfig axisConfig2 = axisConfig;
                    List list4 = list3;
                    Modifier modifier3 = modifier2;
                    boolean bl5 = false;
                    Function2 function2 = (arg_0, arg_1) -> CandlestickChartKt.CandlestickChart$lambda$4$0(dataList, candlestickConfig, bullishColor, bearishColor, animationProgress, arg_0, arg_1);
                    modifier2 = modifier3;
                    list3 = list4;
                    axisConfig = axisConfig2;
                    chartScaffoldConfig = chartScaffoldConfig2;
                    chartOrientation = chartOrientation2;
                    labelRotation = labelRotation2;
                    Function2 value$iv = function2;
                    $this$cache$iv.updateRememberedValue((Object)value$iv);
                    object = value$iv;
                } else {
                    object = it$iv4;
                }
                Function2 function2 = (Function2)object;
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer);
                ChartScaffoldKt.ChartScaffold(modifier2, list3, axisConfig, chartScaffoldConfig, chartOrientation, labelRotation, (Function2<? super DrawScope, ? super ChartContext, Unit>)function2, $composer, 0xE & $dirty >> 3 | 0x1C00 & $dirty >> 6, 48);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block32;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> CandlestickChartKt.CandlestickChart$lambda$5(data, modifier, bullishColor, bearishColor, candlestickConfig, scaffoldConfig, $changed, n, arg_0, arg_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit CandlestickChart$lambda$4$0(List $dataList, CandlestickChartConfig $candlestickConfig, ChartyColor $bullishColor, ChartyColor $bearishColor, Animatable $animationProgress, DrawScope $this$ChartScaffold, ChartContext chartContext) {
        Intrinsics.checkNotNullParameter((Object)$this$ChartScaffold, (String)"$this$ChartScaffold");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        List $this$fastForEachIndexed$iv = $dataList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void candle;
            Object item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            CandleData candleData = (CandleData)item$iv;
            int index = index$iv;
            boolean bl = false;
            float candleX = chartContext.calculateBarLeftPosition(index, $dataList.size(), $candlestickConfig.getCandleWidthFraction());
            float candleWidth = chartContext.calculateBarWidth($dataList.size(), $candlestickConfig.getCandleWidthFraction());
            float openY = chartContext.convertValueToYPosition(candle.getOpen());
            float highY = chartContext.convertValueToYPosition(candle.getHigh());
            float lowY = chartContext.convertValueToYPosition(candle.getLow());
            float closeY = chartContext.convertValueToYPosition(candle.getClose());
            boolean isBullish = candle.isBullish();
            List<Color> candleColor = isBullish ? $bullishColor.getValue() : $bearishColor.getValue();
            float bodyTop = Math.min(openY, closeY);
            float bodyBottom = Math.max(openY, closeY);
            float bodyHeight = bodyBottom - bodyTop;
            float actualBodyHeight = Math.max(bodyHeight, $candlestickConfig.getMinCandleBodyHeight());
            float actualBodyTop = bodyHeight < $candlestickConfig.getMinCandleBodyHeight() ? (openY + closeY - $candlestickConfig.getMinCandleBodyHeight()) / (float)2 : bodyTop;
            float animatedBodyTop = chartContext.getBottom() - (chartContext.getBottom() - actualBodyTop) * ((Number)$animationProgress.getValue()).floatValue();
            float animatedBodyHeight = actualBodyHeight * ((Number)$animationProgress.getValue()).floatValue();
            float animatedHighY = chartContext.getBottom() - (chartContext.getBottom() - highY) * ((Number)$animationProgress.getValue()).floatValue();
            float animatedLowY = chartContext.getBottom() - (chartContext.getBottom() - lowY) * ((Number)$animationProgress.getValue()).floatValue();
            CandlestickChartDrawerKt.drawCandlestick($this$ChartScaffold, new CandlestickDrawParams(Brush.Companion.verticalGradient-8A-3gB4$default((Brush.Companion)Brush.Companion, candleColor, (float)0.0f, (float)0.0f, (int)0, (int)14, null), candleX + candleWidth / (float)2, animatedBodyTop, animatedBodyHeight, candleWidth, animatedHighY, animatedLowY, candleWidth * $candlestickConfig.getWickWidthFraction(), $candlestickConfig.getShowWicks(), $candlestickConfig.getCornerRadius().getValue()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit CandlestickChart$lambda$5(Function0 $data, Modifier $modifier, ChartyColor $bullishColor, ChartyColor $bearishColor, CandlestickChartConfig $candlestickConfig, ChartScaffoldConfig $scaffoldConfig, int $$changed, int $$default, Composer $composer, int $force) {
        CandlestickChartKt.CandlestickChart((Function0<? extends List<CandleData>>)$data, $modifier, $bullishColor, $bearishColor, $candlestickConfig, $scaffoldConfig, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)), $$default);
        return Unit.INSTANCE;
    }
}

