/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.combo.internal;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.combo.config.ComboChartConfig;
import com.himanshoe.charty.combo.data.ComboChartData;
import com.himanshoe.charty.combo.internal.BarDimensions;
import com.himanshoe.charty.combo.internal.ComboChartBarDrawerKt;
import com.himanshoe.charty.combo.internal.ComboChartHelpersKt;
import com.himanshoe.charty.combo.internal.ComboChartLineDrawerKt;
import com.himanshoe.charty.common.ChartContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001af\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013\u0018\u00010\u0012H\u0000\u001a\\\u0010\u0015\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00042\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u001a\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00050\u0013\u0018\u00010\u0012H\u0000\u00a8\u0006\u0019"}, d2={"drawComboBars", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "dataList", "", "Lcom/himanshoe/charty/combo/data/ComboChartData;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "comboConfig", "Lcom/himanshoe/charty/combo/config/ComboChartConfig;", "barColor", "Lcom/himanshoe/charty/color/ChartyColor;", "baselineY", "", "animationProgress", "isBelowAxisMode", "", "dataBounds", "", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Rect;", "drawComboLine", "pointPositions", "Landroidx/compose/ui/geometry/Offset;", "lineColor", "charty_release"})
@SourceDebugExtension(value={"SMAP\nComboChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComboChartDrawer.kt\ncom/himanshoe/charty/combo/internal/ComboChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n71#2,3:115\n75#2:119\n1#3:118\n*S KotlinDebug\n*F\n+ 1 ComboChartDrawer.kt\ncom/himanshoe/charty/combo/internal/ComboChartDrawerKt\n*L\n25#1:115,3\n25#1:119\n*E\n"})
public final class ComboChartDrawerKt {
    /*
     * WARNING - void declaration
     */
    public static final void drawComboBars(@NotNull DrawScope $this$drawComboBars, @NotNull List<ComboChartData> dataList, @NotNull ChartContext chartContext, @NotNull ComboChartConfig comboConfig, @NotNull ChartyColor barColor, float baselineY, float animationProgress, boolean isBelowAxisMode, @Nullable List<Pair<Rect, ComboChartData>> dataBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComboBars, (String)"<this>");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)comboConfig, (String)"comboConfig");
        Intrinsics.checkNotNullParameter((Object)barColor, (String)"barColor");
        List<ComboChartData> $this$fastForEachIndexed$iv = dataList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void comboData;
            ComboChartData item$iv;
            ComboChartData comboChartData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            float barX = chartContext.calculateBarLeftPosition(index, dataList.size(), comboConfig.getBarWidthFraction());
            float barWidth = chartContext.calculateBarWidth(dataList.size(), comboConfig.getBarWidthFraction());
            float barValueY = chartContext.convertValueToYPosition(comboData.getBarValue());
            boolean isNegative = comboData.getBarValue() < 0.0f;
            BarDimensions barDimensions = ComboChartHelpersKt.calculateAnimatedBarDimensions(barValueY, baselineY, isNegative, animationProgress);
            if (dataBounds != null && barDimensions.getHeight() > 0.0f) {
                dataBounds.add((Pair<Rect, ComboChartData>)TuplesKt.to((Object)new Rect(barX, barDimensions.getTop(), barX + barWidth, barDimensions.getTop() + barDimensions.getHeight()), (Object)comboData));
            }
            ChartContext $this$drawComboBars_u24lambda_u240_u240 = chartContext;
            boolean bl2 = false;
            Brush brush = $this$drawComboBars_u24lambda_u240_u240.toVerticalGradientBrush(barColor);
            ComboChartBarDrawerKt.drawRoundedBar($this$drawComboBars, brush, barX, barDimensions.getTop(), barWidth, barDimensions.getHeight(), isNegative, isBelowAxisMode, comboConfig.getBarCornerRadius().getValue());
        }
    }

    public static final void drawComboLine(@NotNull DrawScope $this$drawComboLine, @NotNull List<Offset> pointPositions, @NotNull ChartyColor lineColor, @NotNull ComboChartConfig comboConfig, float animationProgress, @NotNull List<ComboChartData> dataList, @Nullable List<Pair<Rect, ComboChartData>> dataBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$drawComboLine, (String)"<this>");
        Intrinsics.checkNotNullParameter(pointPositions, (String)"pointPositions");
        Intrinsics.checkNotNullParameter((Object)lineColor, (String)"lineColor");
        Intrinsics.checkNotNullParameter((Object)comboConfig, (String)"comboConfig");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        if (comboConfig.getSmoothCurve()) {
            ComboChartLineDrawerKt.drawSmoothCurveLine($this$drawComboLine, pointPositions, lineColor, comboConfig, animationProgress);
        } else {
            ComboChartLineDrawerKt.drawStraightLine($this$drawComboLine, pointPositions, lineColor, comboConfig, animationProgress);
        }
        if (comboConfig.getShowPoints()) {
            List<Pair<Rect, ComboChartData>> list = dataBounds;
            if (list != null) {
                ComboChartHelpersKt.addPointHitAreas(list, pointPositions, dataList, comboConfig, animationProgress);
            }
            ComboChartLineDrawerKt.drawLinePoints($this$drawComboLine, pointPositions, lineColor, comboConfig, animationProgress);
        }
    }
}

