/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.bar.internal.bar.lollipop;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import androidx.compose.ui.text.TextMeasurer;
import com.himanshoe.charty.bar.config.LollipopBarChartConfig;
import com.himanshoe.charty.bar.data.BarData;
import com.himanshoe.charty.bar.internal.bar.lollipop.LollipopChartHelpersKt;
import com.himanshoe.charty.color.ChartyColor;
import com.himanshoe.charty.common.ChartContext;
import com.himanshoe.charty.common.tooltip.TooltipDrawerKt;
import com.himanshoe.charty.common.tooltip.TooltipState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aj\u0010\u0006\u001a\u00020\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00142\u0018\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\u00170\u0016H\u0000\u001a3\u0010\u0019\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001f\u0010 \u001a&\u0010!\u001a\u00020\u0007*\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a.\u0010$\u001a\u00020\u0007*\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"CIRCLE_HIGHLIGHT_OUTER_PADDING", "", "CIRCLE_HIGHLIGHT_INNER_PADDING", "HIGHLIGHT_LINE_WIDTH", "HIGHLIGHT_LINE_ALPHA", "HIGHLIGHT_CIRCLE_ALPHA", "drawLollipops", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "dataList", "", "Lcom/himanshoe/charty/bar/data/BarData;", "chartContext", "Lcom/himanshoe/charty/common/ChartContext;", "config", "Lcom/himanshoe/charty/bar/config/LollipopBarChartConfig;", "animationProgress", "colors", "Lcom/himanshoe/charty/color/ChartyColor;", "onBarClick", "Lkotlin/Function1;", "lollipopBounds", "", "Lkotlin/Pair;", "Landroidx/compose/ui/geometry/Offset;", "drawLollipopCircle", "color", "Landroidx/compose/ui/graphics/Color;", "center", "radius", "strokeWidth", "drawLollipopCircle-Tnrs9kI", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJFF)V", "drawTooltipHighlightIfNeeded", "tooltipState", "Lcom/himanshoe/charty/common/tooltip/TooltipState;", "drawTooltipIfNeeded", "textMeasurer", "Landroidx/compose/ui/text/TextMeasurer;", "charty_release"})
@SourceDebugExtension(value={"SMAP\nLollipopChartDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LollipopChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/lollipop/LollipopChartDrawerKt\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 6 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,156:1\n71#2,3:157\n75#2:176\n30#3:160\n30#3:164\n30#3:168\n30#3:172\n30#3:177\n30#3:184\n30#3:191\n53#4,3:161\n53#4,3:165\n53#4,3:169\n53#4,3:173\n53#4,3:178\n60#4:182\n53#4,3:185\n60#4:189\n53#4,3:192\n65#5:181\n65#5:188\n22#6:183\n22#6:190\n*S KotlinDebug\n*F\n+ 1 LollipopChartDrawer.kt\ncom/himanshoe/charty/bar/internal/bar/lollipop/LollipopChartDrawerKt\n*L\n37#1:157,3\n37#1:176\n46#1:160\n58#1:164\n59#1:168\n66#1:172\n107#1:177\n115#1:184\n116#1:191\n46#1:161,3\n58#1:165,3\n59#1:169,3\n66#1:173,3\n107#1:178,3\n115#1:182\n115#1:185,3\n116#1:189\n116#1:192,3\n115#1:181\n116#1:188\n115#1:183\n116#1:190\n*E\n"})
public final class LollipopChartDrawerKt {
    private static final float CIRCLE_HIGHLIGHT_OUTER_PADDING = 3.0f;
    private static final float CIRCLE_HIGHLIGHT_INNER_PADDING = 2.0f;
    private static final float HIGHLIGHT_LINE_WIDTH = 1.5f;
    private static final float HIGHLIGHT_LINE_ALPHA = 0.1f;
    private static final float HIGHLIGHT_CIRCLE_ALPHA = 0.3f;

    /*
     * WARNING - void declaration
     */
    public static final void drawLollipops(@NotNull DrawScope $this$drawLollipops, @NotNull List<BarData> dataList, @NotNull ChartContext chartContext, @NotNull LollipopBarChartConfig config, float animationProgress, @NotNull ChartyColor colors, @Nullable Function1<? super BarData, Unit> onBarClick, @NotNull List<Pair<Offset, BarData>> lollipopBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$drawLollipops, (String)"<this>");
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter(lollipopBounds, (String)"lollipopBounds");
        float baselineY = chartContext.getBottom();
        List<BarData> $this$fastForEachIndexed$iv = dataList;
        boolean $i$f$fastForEachIndexed = false;
        int n = ((Collection)$this$fastForEachIndexed$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            float x$iv;
            ChartyColor chartyColor;
            ChartyColor chartyColor2;
            ChartyColor chartyColor3;
            void bar;
            BarData item$iv;
            BarData barData = item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            boolean bl = false;
            float barLeft = chartContext.calculateBarLeftPosition(index, dataList.size(), config.getBarWidthFraction());
            float barWidth = chartContext.calculateBarWidth(dataList.size(), config.getBarWidthFraction());
            float centerX = barLeft + barWidth / 2.0f;
            float barValueY = chartContext.convertValueToYPosition(bar.getValue());
            float animatedTopY = baselineY - (baselineY - barValueY) * animationProgress;
            if (onBarClick != null) {
                void x$iv2;
                float f = centerX;
                float y$iv = animatedTopY;
                boolean $i$f$Offset = false;
                boolean $i$f$packFloats = false;
                long v1$iv$iv = Float.floatToRawIntBits((float)x$iv2);
                long v2$iv$iv = Float.floatToRawIntBits(y$iv);
                lollipopBounds.add((Pair<Offset, BarData>)TuplesKt.to((Object)Offset.box-impl((long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL))), (Object)bar));
            }
            if ((chartyColor3 = bar.getColor()) == null) {
                chartyColor3 = chartyColor2 = colors;
            }
            if ((chartyColor = config.getCircleColor()) == null) {
                chartyColor = chartyColor2;
            }
            ChartyColor circleChartyColor = chartyColor;
            Brush stemBrush = LollipopChartHelpersKt.createStemBrush(chartyColor2, baselineY, barValueY);
            long circleColor = LollipopChartHelpersKt.getCircleColor(circleChartyColor, index);
            float f = centerX;
            float y$iv = baselineY;
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            x$iv = centerX;
            y$iv = animatedTopY;
            $i$f$Offset = false;
            $i$f$packFloats = false;
            v1$iv$iv = Float.floatToRawIntBits(x$iv);
            v2$iv$iv = Float.floatToRawIntBits(y$iv);
            DrawScope.drawLine-1RTmtNc$default((DrawScope)$this$drawLollipops, (Brush)stemBrush, (long)l, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (float)config.getStemThickness(), (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
            x$iv = centerX;
            y$iv = animatedTopY;
            $i$f$Offset = false;
            $i$f$packFloats = false;
            v1$iv$iv = Float.floatToRawIntBits(x$iv);
            v2$iv$iv = Float.floatToRawIntBits(y$iv);
            LollipopChartDrawerKt.drawLollipopCircle-Tnrs9kI($this$drawLollipops, circleColor, Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), config.getCircleRadius(), config.getCircleStrokeWidth());
        }
    }

    private static final void drawLollipopCircle-Tnrs9kI(DrawScope $this$drawLollipopCircle_u2dTnrs9kI, long l, long l2, float radius, float strokeWidth) {
        if (strokeWidth > 0.0f) {
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$drawLollipopCircle_u2dTnrs9kI, (long)l, (float)radius, (long)l2, (float)0.0f, (DrawStyle)((DrawStyle)new Stroke(strokeWidth, 0.0f, 0, 0, null, 30, null)), null, (int)0, (int)104, null);
        } else {
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$drawLollipopCircle_u2dTnrs9kI, (long)l, (float)radius, (long)l2, (float)0.0f, null, null, (int)0, (int)120, null);
        }
    }

    public static final void drawTooltipHighlightIfNeeded(@NotNull DrawScope $this$drawTooltipHighlightIfNeeded, @Nullable TooltipState tooltipState, @NotNull LollipopBarChartConfig config, @NotNull ChartContext chartContext) {
        block0: {
            long clickedPosition;
            float y$iv;
            float x$iv;
            Intrinsics.checkNotNullParameter((Object)$this$drawTooltipHighlightIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
            TooltipState tooltipState2 = tooltipState;
            if (tooltipState2 == null) break block0;
            TooltipState state = tooltipState2;
            boolean bl = false;
            float f = state.getX() + config.getCircleRadius();
            float f2 = state.getY();
            boolean $i$f$Offset = false;
            boolean $i$f$packFloats = false;
            long v1$iv$iv = Float.floatToRawIntBits(x$iv);
            long v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long arg0$iv = clickedPosition = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            boolean bl2 = false;
            long value$iv$iv = arg0$iv;
            boolean $i$f$unpackFloat1 = false;
            int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            boolean $i$f$floatFromBits = false;
            x$iv = Float.intBitsToFloat(bits$iv$iv$iv);
            y$iv = chartContext.getTop();
            $i$f$Offset = false;
            $i$f$packFloats = false;
            v1$iv$iv = Float.floatToRawIntBits(x$iv);
            v2$iv$iv = Float.floatToRawIntBits(y$iv);
            long l = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
            arg0$iv = clickedPosition;
            bl2 = false;
            value$iv$iv = arg0$iv;
            $i$f$unpackFloat1 = false;
            bits$iv$iv$iv = (int)(value$iv$iv >> 32);
            $i$f$floatFromBits = false;
            x$iv = Float.intBitsToFloat(bits$iv$iv$iv);
            y$iv = chartContext.getBottom();
            $i$f$Offset = false;
            $i$f$packFloats = false;
            v1$iv$iv = Float.floatToRawIntBits(x$iv);
            v2$iv$iv = Float.floatToRawIntBits(y$iv);
            DrawScope.drawLine-NGM6Ib0$default((DrawScope)$this$drawTooltipHighlightIfNeeded, (long)Color.copy-wmQWz5c$default((long)Color.Companion.getBlack-0d7_KjU(), (float)0.1f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (long)l, (long)Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL)), (float)1.5f, (int)0, null, (float)0.0f, null, (int)0, (int)496, null);
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$drawTooltipHighlightIfNeeded, (long)Color.Companion.getWhite-0d7_KjU(), (float)(config.getCircleRadius() + 3.0f), (long)clickedPosition, (float)0.0f, null, null, (int)0, (int)120, null);
            DrawScope.drawCircle-VaOC9Bg$default((DrawScope)$this$drawTooltipHighlightIfNeeded, (long)Color.copy-wmQWz5c$default((long)Color.Companion.getBlack-0d7_KjU(), (float)0.3f, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null), (float)(config.getCircleRadius() + 2.0f), (long)clickedPosition, (float)0.0f, null, null, (int)0, (int)120, null);
        }
    }

    public static final void drawTooltipIfNeeded(@NotNull DrawScope $this$drawTooltipIfNeeded, @Nullable TooltipState tooltipState, @NotNull LollipopBarChartConfig config, @NotNull TextMeasurer textMeasurer, @NotNull ChartContext chartContext) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$drawTooltipIfNeeded, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)textMeasurer, (String)"textMeasurer");
            Intrinsics.checkNotNullParameter((Object)chartContext, (String)"chartContext");
            TooltipState tooltipState2 = tooltipState;
            if (tooltipState2 == null) break block0;
            TooltipState state = tooltipState2;
            boolean bl = false;
            TooltipDrawerKt.drawTooltip($this$drawTooltipIfNeeded, state, config.getTooltipConfig(), textMeasurer, chartContext.getRight(), chartContext.getTop(), chartContext.getBottom());
        }
    }
}

