/*
 * Decompiled with CFR 0.152.
 */
package com.himanshoe.charty.radar.data;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0005J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/himanshoe/charty/radar/data/RadarAxisData;", "", "label", "", "value", "", "maxValue", "<init>", "(Ljava/lang/String;FF)V", "getLabel", "()Ljava/lang/String;", "getValue", "()F", "getMaxValue", "getNormalizedValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "charty_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nRadarData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarData.kt\ncom/himanshoe/charty/radar/data/RadarAxisData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class RadarAxisData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String label;
    private final float value;
    private final float maxValue;
    public static final int $stable;
    private static final float DEFAULT_MAX_VALUE = 100.0f;

    public RadarAxisData(@NotNull String label, float value, float maxValue) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.label = label;
        this.value = value;
        this.maxValue = maxValue;
        if (!(!StringsKt.isBlank((CharSequence)this.label))) {
            boolean $i$a$-require-RadarAxisData$42 = false;
            String $i$a$-require-RadarAxisData$42 = "Radar axis label cannot be blank";
            throw new IllegalArgumentException($i$a$-require-RadarAxisData$42.toString());
        }
        if (!(this.maxValue > 0.0f)) {
            boolean $i$a$-require-RadarAxisData$52 = false;
            String $i$a$-require-RadarAxisData$52 = "Max value must be positive, got: " + this.maxValue;
            throw new IllegalArgumentException($i$a$-require-RadarAxisData$52.toString());
        }
        if (!(this.value >= 0.0f)) {
            boolean bl = false;
            String string2 = "Value must be non-negative, got: " + this.value;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ RadarAxisData(String string2, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            f2 = 100.0f;
        }
        this(string2, f, f2);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final float getValue() {
        return this.value;
    }

    public final float getMaxValue() {
        return this.maxValue;
    }

    public final float getNormalizedValue() {
        return RangesKt.coerceIn((float)(this.value / this.maxValue), (float)0.0f, (float)1.0f);
    }

    @NotNull
    public final String component1() {
        return this.label;
    }

    public final float component2() {
        return this.value;
    }

    public final float component3() {
        return this.maxValue;
    }

    @NotNull
    public final RadarAxisData copy(@NotNull String label, float value, float maxValue) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return new RadarAxisData(label, value, maxValue);
    }

    public static /* synthetic */ RadarAxisData copy$default(RadarAxisData radarAxisData, String string2, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = radarAxisData.label;
        }
        if ((n & 2) != 0) {
            f = radarAxisData.value;
        }
        if ((n & 4) != 0) {
            f2 = radarAxisData.maxValue;
        }
        return radarAxisData.copy(string2, f, f2);
    }

    @NotNull
    public String toString() {
        return "RadarAxisData(label=" + this.label + ", value=" + this.value + ", maxValue=" + this.maxValue + ")";
    }

    public int hashCode() {
        int result = this.label.hashCode();
        result = result * 31 + Float.hashCode(this.value);
        result = result * 31 + Float.hashCode(this.maxValue);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RadarAxisData)) {
            return false;
        }
        RadarAxisData radarAxisData = (RadarAxisData)other;
        if (!Intrinsics.areEqual((Object)this.label, (Object)radarAxisData.label)) {
            return false;
        }
        if (Float.compare(this.value, radarAxisData.value) != 0) {
            return false;
        }
        return Float.compare(this.maxValue, radarAxisData.maxValue) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/himanshoe/charty/radar/data/RadarAxisData$Companion;", "", "<init>", "()V", "DEFAULT_MAX_VALUE", "", "charty_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

