/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.annotations.SerializedName;
import com.influxdb.client.domain.DocumentLinks;
import com.influxdb.client.domain.DocumentMeta;
import com.influxdb.client.domain.Label;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Document {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private DocumentMeta meta = null;
    public static final String SERIALIZED_NAME_CONTENT = "content";
    @SerializedName(value="content")
    private Object content = null;
    public static final String SERIALIZED_NAME_LABELS = "labels";
    @SerializedName(value="labels")
    private List<Label> labels = new ArrayList<Label>();
    public static final String SERIALIZED_NAME_LINKS = "links";
    @SerializedName(value="links")
    private DocumentLinks links = null;

    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public Document meta(DocumentMeta meta) {
        this.meta = meta;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentMeta getMeta() {
        return this.meta;
    }

    public void setMeta(DocumentMeta meta) {
        this.meta = meta;
    }

    public Document content(Object content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content) {
        this.content = content;
    }

    public Document labels(List<Label> labels) {
        this.labels = labels;
        return this;
    }

    public Document addLabelsItem(Label labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<Label>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Label> getLabels() {
        return this.labels;
    }

    public void setLabels(List<Label> labels) {
        this.labels = labels;
    }

    public Document links(DocumentLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public DocumentLinks getLinks() {
        return this.links;
    }

    public void setLinks(DocumentLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.id, document.id) && Objects.equals(this.meta, document.meta) && Objects.equals(this.content, document.content) && Objects.equals(this.labels, document.labels) && Objects.equals(this.links, document.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.meta, this.content, this.labels, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Document {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

