/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.IRenderer;

class GridItemRenderer
extends BlockRenderer {
    AbstractRenderer renderer;
    private boolean heightSet = false;

    GridItemRenderer() {
        super(new Div());
    }

    @Override
    public void addChild(IRenderer renderer) {
        this.renderer = (AbstractRenderer)renderer;
        super.addChild(renderer);
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(GridItemRenderer.class, this.getClass());
        return new GridItemRenderer();
    }

    @Override
    public <T1> T1 getProperty(int key) {
        switch (key) {
            case 9: 
            case 101: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                Object ownValue = this.getOwnProperty(key);
                if (ownValue != null) {
                    return ownValue;
                }
                return this.renderer.getProperty(key);
            }
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(int property, Object value) {
        switch (property) {
            case 27: {
                if (this.renderer.hasProperty(property) && !this.heightSet) break;
                this.renderer.setProperty(27, value);
                this.renderer.setProperty(85, value);
                this.heightSet = true;
                break;
            }
            case 87: {
                this.renderer.setProperty(property, value);
                break;
            }
            case 9: 
            case 89: 
            case 101: 
            case 147: 
            case 148: 
            case 149: 
            case 150: {
                super.setProperty(property, value);
                break;
            }
        }
    }

    @Override
    void updateHeightsOnSplit(float usedHeight, boolean wasHeightClipped, AbstractRenderer splitRenderer, AbstractRenderer overflowRenderer, boolean enlargeOccupiedAreaOnHeightWasClipped) {
        if (this.heightSet) {
            overflowRenderer.childRenderers.get(0).deleteOwnProperty(27);
        }
    }

    @Override
    void addChildRenderer(IRenderer child) {
        this.renderer = (AbstractRenderer)child;
        super.addChildRenderer(child);
    }

    float calculateHeight(float initialHeight) {
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, 0.0f, initialHeight);
        if (AbstractRenderer.isBorderBoxSizing(this.renderer)) {
            Border borderBottom;
            this.renderer.applyMargins(rectangle, false);
            UnitValue paddingBottom = (UnitValue)this.renderer.getProperty(47);
            if (paddingBottom.isPointValue()) {
                rectangle.decreaseHeight(paddingBottom.getValue());
            }
            if ((borderBottom = this.renderer.getBorders()[2]) != null) {
                rectangle.decreaseHeight(borderBottom.getWidth());
            }
        } else {
            this.renderer.applyMarginsBordersPaddings(rectangle, false);
        }
        return rectangle.getHeight();
    }
}

