/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.resolver.resource;

import com.itextpdf.commons.utils.Base64;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.styledxmlparser.resolver.resource.DefaultResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.IResourceRetriever;
import com.itextpdf.styledxmlparser.resolver.resource.SimpleImageCache;
import com.itextpdf.styledxmlparser.resolver.resource.UriResolver;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceResolver {
    public static final String BASE64_IDENTIFIER = "base64";
    public static final String DATA_SCHEMA_PREFIX = "data:";
    private static final Logger logger = LoggerFactory.getLogger(ResourceResolver.class);
    private UriResolver uriResolver;
    private SimpleImageCache imageCache;
    private IResourceRetriever retriever;

    public ResourceResolver(String baseUri) {
        this(baseUri, null);
    }

    public ResourceResolver(String baseUri, IResourceRetriever retriever) {
        if (baseUri == null) {
            baseUri = "";
        }
        this.uriResolver = new UriResolver(baseUri);
        this.imageCache = new SimpleImageCache();
        this.retriever = retriever == null ? new DefaultResourceRetriever() : retriever;
    }

    public IResourceRetriever getRetriever() {
        return this.retriever;
    }

    public ResourceResolver setRetriever(IResourceRetriever retriever) {
        this.retriever = retriever;
        return this;
    }

    public PdfXObject retrieveImage(String src) {
        if (src != null) {
            PdfXObject imageXObject;
            if (this.isContains64Mark(src) && (imageXObject = this.tryResolveBase64ImageSource(src)) != null) {
                return imageXObject;
            }
            imageXObject = this.tryResolveUrlImageSource(src);
            if (imageXObject != null) {
                return imageXObject;
            }
        }
        if (ResourceResolver.isDataSrc(src)) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve image with data URI {0}", (Object[])new Object[]{src}));
        } else {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve image with given base URI ({0}) and image source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}));
        }
        return null;
    }

    public byte[] retrieveBytesFromResource(String src) {
        byte[] bytes = this.retrieveBytesFromBase64Src(src);
        if (bytes != null) {
            return bytes;
        }
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(src);
            return this.retriever.getByteArrayByUrl(url);
        }
        catch (Exception e) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    public InputStream retrieveResourceAsInputStream(String src) {
        byte[] bytes = this.retrieveBytesFromBase64Src(src);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(src);
            return this.retriever.getInputStreamByUrl(url);
        }
        catch (Exception e) {
            logger.error(MessageFormatUtil.format((String)"Unable to retrieve stream with given base URI ({0}) and source path ({1})", (Object[])new Object[]{this.uriResolver.getBaseUri(), src}), (Throwable)e);
            return null;
        }
    }

    public static boolean isDataSrc(String src) {
        return src != null && src.toLowerCase().startsWith(DATA_SCHEMA_PREFIX) && src.contains(",");
    }

    public URL resolveAgainstBaseUri(String uri) throws MalformedURLException {
        return this.uriResolver.resolveAgainstBaseUri(uri);
    }

    public String getBaseUri() {
        return this.uriResolver.getBaseUri();
    }

    public void resetCache() {
        this.imageCache.reset();
    }

    protected PdfXObject tryResolveBase64ImageSource(String src) {
        try {
            String fixedSrc = src.replaceAll("\\s", "");
            fixedSrc = fixedSrc.substring(fixedSrc.indexOf(BASE64_IDENTIFIER) + BASE64_IDENTIFIER.length() + 1);
            PdfXObject imageXObject = this.imageCache.getImage(fixedSrc);
            if (imageXObject == null) {
                imageXObject = new PdfImageXObject(ImageDataFactory.create((byte[])Base64.decode((String)fixedSrc)));
                this.imageCache.putImage(fixedSrc, imageXObject);
            }
            return imageXObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PdfXObject tryResolveUrlImageSource(String uri) {
        try {
            URL url = this.uriResolver.resolveAgainstBaseUri(uri);
            String imageResolvedSrc = url.toExternalForm();
            PdfXObject imageXObject = this.imageCache.getImage(imageResolvedSrc);
            if (imageXObject == null) {
                boolean isAbsoluteSized;
                imageXObject = this.createImageByUrl(url);
                boolean bl = isAbsoluteSized = imageXObject != null && (!(imageXObject instanceof PdfFormXObject) || !((PdfFormXObject)imageXObject).isRelativeSized());
                if (isAbsoluteSized) {
                    this.imageCache.putImage(imageResolvedSrc, imageXObject);
                }
            }
            return imageXObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PdfXObject createImageByUrl(URL url) throws Exception {
        byte[] bytes = this.retriever.getByteArrayByUrl(url);
        return bytes == null ? null : new PdfImageXObject(ImageDataFactory.create((byte[])bytes));
    }

    private byte[] retrieveBytesFromBase64Src(String src) {
        if (this.isContains64Mark(src)) {
            try {
                String fixedSrc = src.replaceAll("\\s", "");
                fixedSrc = fixedSrc.substring(fixedSrc.indexOf(BASE64_IDENTIFIER) + BASE64_IDENTIFIER.length() + 1);
                return Base64.decode((String)fixedSrc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isContains64Mark(String src) {
        return src.contains(BASE64_IDENTIFIER);
    }
}

