/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.TestClassPerformance;

public class TestClass
implements Runnable {
    static final int THREADS = 25000;
    private int threadNum;
    long lobits;
    long hibits;
    Monitor mon;

    public TestClass(int threadNum, long lobits, long hibits, Monitor mon) {
        this.threadNum = threadNum;
        this.lobits = lobits;
        this.hibits = hibits;
        this.mon = mon;
    }

    public void run() {
        try {
            long incr = 0L;
            incr = this.threadNum % 2 == 0 ? this.lobits : this.hibits;
            this.mon.add(incr);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void testMonKey(String label) {
        System.out.println("\n***** Testing getLabel, getUnits, getMonKey, getRange for " + label);
        Monitor mon = MonitorFactory.start(label).stop();
        System.out.println(mon.getMonKey());
        System.out.println(mon.getLabel());
        System.out.println(mon.getUnits());
        System.out.println(mon.getMonKey().getValue("label"));
        System.out.println(mon.getMonKey().getValue("Units"));
        System.out.println(mon.getRange());
    }

    public static void main(String[] args) throws Exception {
        Monitor totalMon = MonitorFactory.start();
        System.out.println("***** Class unit tests");
        System.out.println("\nMonitorFactory.main()");
        MonitorFactory.main(null);
        System.out.println("\nTestClassPerformance.main()");
        TestClassPerformance.main(args);
        System.out.println("\n***** MonitorFactory.getData():");
        Monitor m1 = MonitorFactory.start("pages.purchase.test");
        Monitor m2 = MonitorFactory.start("steve.souza.test");
        Thread.sleep(350L);
        m1.stop();
        Thread.sleep(650L);
        m2.stop();
        Object[][] rows = MonitorFactory.getData();
        for (int i = 0; i < rows.length; ++i) {
            String rowData = "row" + i + "=[";
            for (int j = 0; j < rows[0].length; ++j) {
                rowData = rowData + rows[i][j] + ", ";
            }
            System.out.println(rowData + "]");
        }
        System.out.println("\n***** Multi-threaded test");
        long LOBIT = 1L;
        long HIBIT = 0x10000000L;
        Monitor timingMon = MonitorFactory.start();
        ThreadGroup threadGroup = new ThreadGroup("threadGroup");
        Monitor mon1 = MonitorFactory.getTimeMonitor("mon1");
        for (int i = 0; i < 25000; ++i) {
            new Thread(threadGroup, new TestClass(i, LOBIT, LOBIT, mon1)).start();
        }
        Monitor mon2 = MonitorFactory.getTimeMonitor("mon2");
        for (int i = 0; i < 25000; ++i) {
            new Thread(threadGroup, new TestClass(i, HIBIT, HIBIT, mon2)).start();
        }
        Monitor mon3 = MonitorFactory.getTimeMonitor("mon3");
        for (int i = 0; i < 25000; ++i) {
            new Thread(threadGroup, new TestClass(i, LOBIT, HIBIT, mon3)).start();
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("Threads have finished processing. It took " + timingMon.stop());
        System.out.println("Total should equal 25000 - " + mon1);
        System.out.println("Total should equal " + 25000L * HIBIT + " - " + mon2);
        double threadCount = 12500.0;
        System.out.println("Total should equal " + (threadCount * (double)LOBIT + threadCount * (double)HIBIT) + " - " + mon3);
        Monitor mon4 = MonitorFactory.start("mon4");
        System.out.println("\nStarting mon4 thread test");
        Monitor mon4ThreadTest = MonitorFactory.start();
        threadGroup = new ThreadGroup("timingMonitorThreads");
        for (int i = 0; i < 25000; ++i) {
            new Thread(threadGroup, new TimingMonitorThreads(mon4)).start();
        }
        while (threadGroup.activeCount() != 0) {
        }
        System.out.println("hits should be 25001= " + mon4.stop());
        System.out.println("'multi-threaded test' hits should equal 100000 - " + MonitorFactory.getMonitor("multi-threaded test", "ms."));
        System.out.println("Time for mon4 thread test=" + mon4ThreadTest.stop());
        System.out.println("\n***** MonitorFactory.getHeader():");
        String[] header = MonitorFactory.getHeader();
        for (int i = 0; i < header.length; ++i) {
            System.out.println(header[i]);
        }
        TestClass.testMonKey("TestingMonKey");
        MonitorFactory.disable();
        TestClass.testMonKey("DisableTestingMonKey");
        MonitorFactory.enable();
        System.out.println("\n***** MonitorFactory.getReport() 1:");
        System.out.println(MonitorFactory.getReport());
        System.out.println("\n***** Total Execution Time=" + totalMon.stop());
    }

    private static class TimingMonitorThreads
    implements Runnable {
        Monitor mon;

        TimingMonitorThreads(Monitor mon) {
            this.mon = mon;
        }

        public void run() {
            this.mon.start().stop();
            MonitorFactory.start("multi-threaded test").stop();
            MonitorFactory.start("multi-threaded test").stop();
            MonitorFactory.start("multi-threaded test").stop();
            MonitorFactory.start("multi-threaded test").stop();
        }
    }
}

