/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi.proxy;

import [Ljava.lang.String;;
import com.jamonapi.FactoryEnabled;
import com.jamonapi.Monitor;
import com.jamonapi.MonitorFactory;
import com.jamonapi.proxy.MonProxyFactory;
import com.jamonapi.proxy.Params;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class MonProxyTester {
    private static int testCounter = 0;

    private static void printDebug(String title, Object[][] data) {
        System.out.println("\n***" + title + "***");
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                System.out.print("row=" + i + " - ");
                for (int j = 0; j < data[0].length; ++j) {
                    System.out.print(data[i][j] + ", ");
                }
                System.out.println();
            }
        }
    }

    private static ResultSet testStatement(Connection conn) throws Exception {
        Statement st = conn.createStatement();
        ResultSet rs = st.executeQuery("select * from SYSTEM_TYPEINFO where LOCAL_TYPE_NAME='INTEGER'");
        return rs;
    }

    private static ResultSet testPreparedStatement(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select * from SYSTEM_TYPEINFO where LOCAL_TYPE_NAME=?");
        ps.setString(1, "INTEGER");
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    private static void throwException(Connection conn) {
        try {
            Statement st = conn.createStatement();
            st.executeQuery("select * from I_DO_NOT_EXIST where LOCAL_TYPE_NAME='INTEGER'");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static PreparedStatement getPreparedStatement(Connection conn) throws Exception {
        PreparedStatement ps = conn.prepareStatement("select *,'PreparedStatement Reuse Query' from SYSTEM_TYPEINFO where LOCAL_TYPE_NAME=?");
        ps.setString(1, "INTEGER");
        return ps;
    }

    private static void testLoopResultSet(ResultSet rs) throws Exception {
        while (rs.next()) {
            rs.getObject(1);
        }
    }

    private static void testDisplayResultSet(ResultSet rs) throws Exception {
        while (rs.next()) {
            System.out.println(rs.getObject(1) + " ");
        }
    }

    private static void testInterfaces(Class cls) {
        System.out.println("\nInterfaceHeirarchy for " + cls);
        Class[] ifaces = MonProxyFactory.getInterfaces(cls);
        int len = ifaces == null ? 0 : ifaces.length;
        for (int i = 0; i < len; ++i) {
            System.out.println(i + ") " + ifaces[i]);
        }
    }

    private static void mainTestMethod(String name, Connection conn, int times, Params params, FactoryEnabled mf) throws Exception {
        System.out.println("\n\n\n" + ++testCounter + ") " + name + "** " + params);
        Monitor mon = mf.start(testCounter + ") " + name + " ** " + params.toString());
        Monitor monTotal = mf.start("totalTime");
        MonProxyFactory.enableResultSet(params.isResultSetEnabled);
        MonProxyFactory.enableInterface(params.isInterfaceEnabled);
        MonProxyFactory.enableSQLDetail(params.isSQLDetailEnabled);
        MonProxyFactory.enableSQLSummary(params.isSQLSummaryEnabled);
        MonProxyFactory.enableExceptionSummary(params.isExceptionSummaryEnabled);
        MonProxyFactory.enableExceptionDetail(params.isExceptionDetailEnabled);
        MonProxyFactory.enable(params.isEnabled);
        PreparedStatement ps = MonProxyTester.getPreparedStatement(conn);
        for (int i = 0; i < times; ++i) {
            ps.executeQuery();
            MonProxyTester.testLoopResultSet(MonProxyTester.testStatement(conn));
            MonProxyTester.testLoopResultSet(MonProxyTester.testPreparedStatement(conn));
        }
        MonProxyTester.throwException(conn);
        monTotal.stop();
        String message = name + " execution time: " + mon.stop().getLastValue();
        System.out.println(message);
        MonProxyTester.printDebug(testCounter + ".1) " + "sqlBuffer", MonProxyFactory.getSQLDetail());
        MonProxyTester.printDebug(testCounter + ".2) " + "exceptionsBuffer", MonProxyFactory.getExceptionDetail());
        MonProxyTester.printDebug(testCounter + ".3) " + "jamon data - " + message, MonitorFactory.getRootMonitor().getBasicData());
        MonProxyFactory.resetSQLDetail();
        MonProxyFactory.resetExceptionDetail();
        MonitorFactory.reset();
    }

    private static void testEquals() {
        MyClass0 noProxyObj = new MyClass0();
        Tag0 proxyObj = (Tag0)MonProxyFactory.monitor(noProxyObj);
        Tag0 proxyObj2 = (Tag0)MonProxyFactory.monitor(noProxyObj);
        Tag0 proxyObjTwice = (Tag0)MonProxyFactory.monitor(proxyObj);
        System.out.println("\nAll of the following should equal true");
        System.out.println("proxy.equals(noproxy)=" + proxyObj.equals(noProxyObj));
        System.out.println("proxy.equals(proxy)=" + proxyObj.equals(proxyObj));
        System.out.println("proxy1.equals(proxy2)=" + proxyObj.equals(proxyObj2));
        System.out.println("proxy2.equals(proxy1)=" + proxyObj2.equals(proxyObj));
        System.out.println("proxyObjTwice.equals(proxy1)=" + proxyObj.equals(proxyObjTwice));
        System.out.println("noproxy.equals(noproxy)=" + noProxyObj.equals(noProxyObj));
        System.out.println("\nAll of the following will equal false");
        System.out.println("noproxy.equals(proxy)=" + noProxyObj.equals(proxyObj) + " - will be false as the nonproxied class will not no that a proxied class is the same.");
        System.out.println("proxyObjTwice.equals(null)=" + proxyObj.equals(null));
    }

    public static void main(String[] args) throws Exception {
        int times = 2000;
        Params params = new Params();
        FactoryEnabled mf = new FactoryEnabled();
        Class.forName("org.hsqldb.jdbcDriver");
        Connection conn = DriverManager.getConnection("jdbc:hsqldb:.", "sa", "");
        MonProxyTester.mainTestMethod("Non monitored connection first time", conn, times, params, mf);
        MonProxyTester.mainTestMethod("Non monitored connection second time", conn, times, params, mf);
        MonProxyFactory.enableAll(false);
        conn = MonProxyFactory.monitor(conn);
        MonProxyTester.mainTestMethod("MonProxyFactory disabled at creation of Connection (should be fast as regular connection)", conn, times, params, mf);
        MonProxyFactory.enableAll(true);
        conn = MonProxyFactory.monitor(conn);
        MonProxyTester.mainTestMethod("MonProxyFactory defaults first time", conn, times, params, mf);
        MonProxyTester.mainTestMethod("MonProxyFactory defaults second time", conn, times, params, mf);
        params = new Params();
        params.isResultSetEnabled = true;
        MonProxyTester.mainTestMethod("MonProxyFactory all enabled", conn, times, params, mf);
        params = new Params();
        params.isEnabled = false;
        MonProxyTester.mainTestMethod("MonProxyFactory disabled (uses monitored connection but disabled)", conn, times, params, mf);
        params = new Params();
        params.isInterfaceEnabled = false;
        MonProxyTester.mainTestMethod("interface disabled", conn, times, params, mf);
        params = new Params();
        params.isInterfaceEnabled = false;
        params.isSQLDetailEnabled = false;
        MonProxyTester.mainTestMethod("sql detail and interface disabled", conn, times, params, mf);
        params = new Params();
        ArrayList<String> list = new ArrayList<String>();
        list.add("SYSTEM_TYPEINFO");
        list.add("LOCAL_TYPE_NAME");
        MonProxyFactory.setMatchStrings(list);
        MonProxyTester.mainTestMethod("MonProxy defaults with keyword match", conn, times, params, mf);
        MonProxyFactory.setMatchStrings(null);
        System.out.println("\n\n**** ResultSets *****");
        MonProxyTester.testDisplayResultSet(MonProxyTester.testStatement(conn));
        MonProxyTester.testDisplayResultSet(MonProxyTester.testPreparedStatement(conn));
        conn.close();
        MonProxyTester.printDebug("totals", mf.getRootMonitor().getBasicData());
        MonProxyTester.testInterfaces(new MyClass0().getClass());
        MonProxyTester.testInterfaces(new MyClass1().getClass());
        MonProxyTester.testInterfaces(null);
        MonProxyTester.testInterfaces(String;.class);
        MyClass1 obj = new MyClass1();
        MonProxyTester.testInterfaces(obj.getClass());
        MonProxyTester.testEquals();
    }

    private static class MyClass1
    extends MyClass0
    implements Tag1 {
        private MyClass1() {
        }
    }

    private static class MyClass0
    implements Base2 {
        private MyClass0() {
        }
    }

    private static interface Base2
    extends Base1,
    Tag0,
    Base0 {
    }

    private static interface Base1
    extends Base0 {
    }

    private static interface Base0
    extends Tag0 {
    }

    private static interface Tag1 {
    }

    private static interface Tag0 {
    }
}

