/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal;

import com.jayway.jsonpath.InvalidPathException;

public class CharacterIndex {
    private static final char OPEN_BRACKET = '(';
    private static final char CLOSE_BRACKET = ')';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char SPACE = ' ';
    private static final char ESCAPE = '\\';
    private static final char TICK = '\'';
    private static final char MINUS = '-';
    private static final char PERIOD = '.';
    private static final char REGEX = '/';
    private final CharSequence charSequence;
    private int position;

    public CharacterIndex(CharSequence charSequence) {
        this.charSequence = charSequence;
        this.position = 0;
    }

    public int length() {
        return this.charSequence.length();
    }

    public char charAt(int idx) {
        return this.charSequence.charAt(idx);
    }

    public char currentChar() {
        return this.charSequence.charAt(this.position);
    }

    public boolean currentCharIs(char c) {
        return this.charSequence.charAt(this.position) == c;
    }

    public boolean nextCharIs(char c) {
        return this.inBounds(this.position + 1) && this.charSequence.charAt(this.position + 1) == c;
    }

    public int incrementPosition(int charCount) {
        return this.setPosition(this.position + charCount);
    }

    public int setPosition(int newPosition) {
        this.position = newPosition;
        return this.position;
    }

    public int position() {
        return this.position;
    }

    public int indexOfClosingSquareBracket(int startPosition) {
        int readPosition = startPosition;
        while (this.inBounds(readPosition)) {
            if (this.charAt(readPosition) == ']') {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public int indexOfMatchingCloseChar(int startPosition, char openChar, char closeChar, boolean skipStrings, boolean skipRegex) {
        if (this.charAt(startPosition) != openChar) {
            throw new InvalidPathException("Expected " + openChar + " but found " + this.charAt(startPosition));
        }
        int opened = 1;
        int readPosition = startPosition + 1;
        while (this.inBounds(readPosition)) {
            if (skipStrings && this.charAt(readPosition) == '\'') {
                boolean escaped = false;
                while (this.inBounds(readPosition)) {
                    ++readPosition;
                    if (escaped) {
                        escaped = false;
                        continue;
                    }
                    if (this.charAt(readPosition) == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (this.charAt(readPosition) != '\'') continue;
                    ++readPosition;
                    break;
                }
            }
            if (skipRegex && this.charAt(readPosition) == '/') {
                while (this.inBounds(readPosition)) {
                    if (this.charAt(++readPosition) != '/') continue;
                    ++readPosition;
                    break;
                }
            }
            if (this.charAt(readPosition) == openChar) {
                ++opened;
            }
            if (this.charAt(readPosition) == closeChar && --opened == 0) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public int indexOfClosingBracket(int startPosition, boolean skipStrings, boolean skipRegex) {
        return this.indexOfMatchingCloseChar(startPosition, '(', ')', skipStrings, skipRegex);
    }

    public int indexOfNextSignificantChar(char c) {
        return this.indexOfNextSignificantChar(this.position, c);
    }

    public int indexOfNextSignificantChar(int startPosition, char c) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        if (this.charAt(readPosition) == c) {
            return readPosition;
        }
        return -1;
    }

    public int nextIndexOf(char c) {
        return this.nextIndexOf(this.position + 1, c);
    }

    public int nextIndexOf(int startPosition, char c) {
        int readPosition = startPosition;
        while (!this.isOutOfBounds(readPosition)) {
            if (this.charAt(readPosition) == c) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public int nextIndexOfUnescaped(char c) {
        return this.nextIndexOfUnescaped(this.position + 1, c);
    }

    public int nextIndexOfUnescaped(int startPosition, char c) {
        int readPosition = startPosition;
        while (!this.isOutOfBounds(readPosition)) {
            boolean escaped;
            char prev1 = this.charAtOr(readPosition - 1, ' ');
            char prev2 = this.charAtOr(readPosition - 2, ' ');
            boolean ignore = prev1 == '\\' && prev2 == '\\';
            boolean bl = escaped = prev1 == '\\' && !ignore;
            if (this.charAt(readPosition) == c && !escaped) {
                return readPosition;
            }
            ++readPosition;
        }
        return -1;
    }

    public char charAtOr(int postition, char defaultChar) {
        if (!this.inBounds(postition)) {
            return defaultChar;
        }
        return this.charAt(postition);
    }

    public boolean nextSignificantCharIs(int startPosition, char c) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        return !this.isOutOfBounds(readPosition) && this.charAt(readPosition) == c;
    }

    public boolean nextSignificantCharIs(char c) {
        return this.nextSignificantCharIs(this.position, c);
    }

    public char nextSignificantChar() {
        return this.nextSignificantChar(this.position);
    }

    public char nextSignificantChar(int startPosition) {
        int readPosition = startPosition + 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            ++readPosition;
        }
        if (!this.isOutOfBounds(readPosition)) {
            return this.charAt(readPosition);
        }
        return ' ';
    }

    public int indexOfPreviousSignificantChar(int startPosition) {
        int readPosition = startPosition - 1;
        while (!this.isOutOfBounds(readPosition) && this.charAt(readPosition) == ' ') {
            --readPosition;
        }
        if (!this.isOutOfBounds(readPosition)) {
            return readPosition;
        }
        return -1;
    }

    public int indexOfPreviousSignificantChar() {
        return this.indexOfPreviousSignificantChar(this.position);
    }

    public char previousSignificantChar(int startPosition) {
        int previousSignificantCharIndex = this.indexOfPreviousSignificantChar(startPosition);
        if (previousSignificantCharIndex == -1) {
            return ' ';
        }
        return this.charAt(previousSignificantCharIndex);
    }

    public char previousSignificantChar() {
        return this.previousSignificantChar(this.position);
    }

    public boolean currentIsTail() {
        return this.isOutOfBounds(this.position + 1);
    }

    public boolean hasMoreCharacters() {
        return this.inBounds(this.position + 1);
    }

    public boolean inBounds(int idx) {
        return idx >= 0 && idx < this.charSequence.length();
    }

    public boolean inBounds() {
        return this.inBounds(this.position);
    }

    public boolean isOutOfBounds(int idx) {
        return !this.inBounds(idx);
    }

    public CharSequence subSequence(int start, int end) {
        return this.charSequence.subSequence(start, end);
    }

    public CharSequence charSequence() {
        return this.charSequence;
    }

    public String toString() {
        return this.charSequence.toString();
    }

    public boolean isNumberCharacter(int readPosition) {
        char c = this.charAt(readPosition);
        return Character.isDigit(c) || c == '-' || c == '.';
    }

    public CharacterIndex skipBlanks() {
        while (this.inBounds() && this.currentChar() == ' ') {
            this.incrementPosition(1);
        }
        return this;
    }
}

