/*
 * Decompiled with CFR 0.152.
 */
package com.maciejwalkowiak.spring.boot.startup;

import com.maciejwalkowiak.spring.boot.startup.ReportRenderer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;

public class StartupEventsCustomizer
implements ContextCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupEventsCustomizer.class);
    private final String testName;

    public StartupEventsCustomizer(String name) {
        this.testName = name;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        context.addApplicationListener(event -> {
            if (event instanceof ContextClosedEvent) {
                try {
                    ReportRenderer reportRenderer = (ReportRenderer)context.getBean(ReportRenderer.class);
                    try {
                        Path buildDirectory = StartupEventsCustomizer.resolveReportDirectory();
                        Path path = Files.write(buildDirectory.resolve(Paths.get(this.reportName(), new String[0])), reportRenderer.render().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        LOGGER.debug("Report for test {} saved to {}", (Object)this.testName, (Object)path.toAbsolutePath());
                    }
                    catch (IOException e) {
                        LOGGER.error("Error during rendering analysis report", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                catch (NoSuchBeanDefinitionException e) {
                    LOGGER.warn("Report for test {} not generated", (Object)this.testName, (Object)e);
                }
            }
        });
    }

    private static Path resolveReportDirectory() throws IOException {
        Path mavenTarget = Paths.get("target", new String[0]);
        Path gradleBuild = Paths.get("build", new String[0]);
        Path buildDirectory = Files.exists(mavenTarget, new LinkOption[0]) ? mavenTarget : (Files.exists(gradleBuild, new LinkOption[0]) ? gradleBuild : Paths.get(".", new String[0]));
        Path reportDirectory = buildDirectory.resolve("startup-reports");
        if (!Files.exists(reportDirectory, new LinkOption[0])) {
            Files.createDirectories(reportDirectory, new FileAttribute[0]);
        }
        return reportDirectory;
    }

    private String reportName() {
        return "startup-report-" + this.testName + ".html";
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

