/*
 * Decompiled with CFR 0.152.
 */
package name.fraser.neil.plaintext;

import java.util.regex.Pattern;
import name.fraser.neil.plaintext.SemanticBreakScorer;

public class StandardBreakScorer
implements SemanticBreakScorer {
    private final Pattern BLANKLINEEND = Pattern.compile("\\n\\r?\\n\\Z", 32);
    private final Pattern BLANKLINESTART = Pattern.compile("\\A\\r?\\n\\r?\\n", 32);

    @Override
    public int scoreBreakOver(String one, String two) {
        if (one.length() == 0 || two.length() == 0) {
            return 5;
        }
        int score = 0;
        char endOne = one.charAt(one.length() - 1);
        char startTwo = two.charAt(0);
        if (!Character.isLetterOrDigit(endOne) || !Character.isLetterOrDigit(startTwo)) {
            ++score;
            if (Character.isWhitespace(endOne) || Character.isWhitespace(startTwo)) {
                ++score;
                if (Character.getType(endOne) == 15 || Character.getType(startTwo) == 15) {
                    ++score;
                    if (this.BLANKLINEEND.matcher(one).find() || this.BLANKLINESTART.matcher(two).find()) {
                        ++score;
                    }
                }
            }
        }
        return score;
    }
}

