/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.spring;

import com.wordnik.swagger.core.DocumentationOperation;
import com.wordnik.swagger.core.DocumentationParameter;

public class UriBuilder {
    private StringBuilder sb = new StringBuilder();
    boolean queryParamAdded = false;

    public UriBuilder() {
    }

    public UriBuilder(String uri) {
        this.sb.append(uri);
    }

    public static String fromOperation(String basePath, DocumentationOperation operation) {
        UriBuilder builder = new UriBuilder(basePath);
        for (DocumentationParameter parameter : operation.getParameters()) {
            if ("path".equals(parameter.getParamType())) {
                builder.appendPath(parameter.name());
                continue;
            }
            if (!"query".equals(parameter.name())) continue;
            builder.appendQueryString(parameter.name());
        }
        return builder.toString();
    }

    public UriBuilder appendPath(String segment) {
        if (!this.sb.toString().endsWith("/")) {
            this.sb.append("/");
        }
        if (segment.startsWith("/")) {
            this.sb.append(segment.substring(1));
        } else {
            this.sb.append(segment);
        }
        return this;
    }

    private void appendQueryString(String parameterName) {
        if (this.queryParamAdded) {
            this.sb.append(String.format("&%s={%s}", parameterName, parameterName));
        } else {
            this.sb.append(String.format("?%s={%s}", parameterName, parameterName));
        }
    }

    public String toString() {
        return this.sb.toString();
    }
}

