/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.AvailabilitySet;
import com.microsoft.azure.management.compute.models.AvailabilitySetCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.AvailabilitySetGetResponse;
import com.microsoft.azure.management.compute.models.AvailabilitySetListResponse;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.VirtualMachineReference;
import com.microsoft.azure.management.compute.models.VirtualMachineSize;
import com.microsoft.azure.management.compute.models.VirtualMachineSizeListResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing the availability sets in compute management.
*/
public class AvailabilitySetOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, AvailabilitySetOperations {
    /**
    * Initializes a new instance of the AvailabilitySetOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    AvailabilitySetOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The operation to create or update the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create
    * Availability Set operation.
    * @return The Create Availability Set operation response.
    */
    @Override
    public Future<AvailabilitySetCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final AvailabilitySet parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetCreateOrUpdateResponse>() { 
            @Override
            public AvailabilitySetCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * The operation to create or update the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create
    * Availability Set operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The Create Availability Set operation response.
    */
    @Override
    public AvailabilitySetCreateOrUpdateResponse createOrUpdate(String resourceGroupName, AvailabilitySet parameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        if (parameters.getName() != null) {
            url = url + URLEncoder.encode(parameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode availabilitySetJsonValue = objectMapper.createObjectNode();
        requestDoc = availabilitySetJsonValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) availabilitySetJsonValue).put("properties", propertiesValue);
        
        if (parameters.getPlatformUpdateDomainCount() != null) {
            ((ObjectNode) propertiesValue).put("platformUpdateDomainCount", parameters.getPlatformUpdateDomainCount());
        }
        
        if (parameters.getPlatformFaultDomainCount() != null) {
            ((ObjectNode) propertiesValue).put("platformFaultDomainCount", parameters.getPlatformFaultDomainCount());
        }
        
        if (parameters.getVirtualMachinesReferences() != null) {
            if (parameters.getVirtualMachinesReferences() instanceof LazyCollection == false || ((LazyCollection) parameters.getVirtualMachinesReferences()).isInitialized()) {
                ArrayNode virtualMachinesArray = objectMapper.createArrayNode();
                for (VirtualMachineReference virtualMachinesItem : parameters.getVirtualMachinesReferences()) {
                    ObjectNode virtualMachineReferenceValue = objectMapper.createObjectNode();
                    virtualMachinesArray.add(virtualMachineReferenceValue);
                    
                    if (virtualMachinesItem.getReferenceUri() != null) {
                        ((ObjectNode) virtualMachineReferenceValue).put("id", virtualMachinesItem.getReferenceUri());
                    }
                }
                ((ObjectNode) propertiesValue).put("virtualMachines", virtualMachinesArray);
            }
        }
        
        if (parameters.getStatuses() != null) {
            if (parameters.getStatuses() instanceof LazyCollection == false || ((LazyCollection) parameters.getStatuses()).isInitialized()) {
                ArrayNode statusesArray = objectMapper.createArrayNode();
                for (InstanceViewStatus statusesItem : parameters.getStatuses()) {
                    ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                    statusesArray.add(instanceViewStatusValue);
                    
                    if (statusesItem.getCode() != null) {
                        ((ObjectNode) instanceViewStatusValue).put("code", statusesItem.getCode());
                    }
                    
                    if (statusesItem.getLevel() != null) {
                        ((ObjectNode) instanceViewStatusValue).put("level", statusesItem.getLevel());
                    }
                    
                    if (statusesItem.getDisplayStatus() != null) {
                        ((ObjectNode) instanceViewStatusValue).put("displayStatus", statusesItem.getDisplayStatus());
                    }
                    
                    if (statusesItem.getMessage() != null) {
                        ((ObjectNode) instanceViewStatusValue).put("message", statusesItem.getMessage());
                    }
                    
                    if (statusesItem.getTime() != null) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) instanceViewStatusValue).put("time", simpleDateFormat.format(statusesItem.getTime().getTime()));
                    }
                }
                ((ObjectNode) propertiesValue).put("statuses", statusesArray);
            }
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) availabilitySetJsonValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) availabilitySetJsonValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) availabilitySetJsonValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) availabilitySetJsonValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) availabilitySetJsonValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            AvailabilitySetCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AvailabilitySetCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    AvailabilitySet availabilitySetInstance = new AvailabilitySet();
                    result.setAvailabilitySet(availabilitySetInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode platformUpdateDomainCountValue = propertiesValue2.get("platformUpdateDomainCount");
                        if (platformUpdateDomainCountValue != null && platformUpdateDomainCountValue instanceof NullNode == false) {
                            int platformUpdateDomainCountInstance;
                            platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                        }
                        
                        JsonNode platformFaultDomainCountValue = propertiesValue2.get("platformFaultDomainCount");
                        if (platformFaultDomainCountValue != null && platformFaultDomainCountValue instanceof NullNode == false) {
                            int platformFaultDomainCountInstance;
                            platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                        }
                        
                        JsonNode virtualMachinesArray2 = propertiesValue2.get("virtualMachines");
                        if (virtualMachinesArray2 != null && virtualMachinesArray2 instanceof NullNode == false) {
                            for (JsonNode virtualMachinesValue : ((ArrayNode) virtualMachinesArray2)) {
                                VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                availabilitySetInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                
                                JsonNode idValue = virtualMachinesValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    virtualMachineReferenceInstance.setReferenceUri(idInstance);
                                }
                            }
                        }
                        
                        JsonNode statusesArray2 = propertiesValue2.get("statuses");
                        if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                            for (JsonNode statusesValue : ((ArrayNode) statusesArray2)) {
                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                availabilitySetInstance.getStatuses().add(instanceViewStatusInstance);
                                
                                JsonNode codeValue = statusesValue.get("code");
                                if (codeValue != null && codeValue instanceof NullNode == false) {
                                    String codeInstance;
                                    codeInstance = codeValue.getTextValue();
                                    instanceViewStatusInstance.setCode(codeInstance);
                                }
                                
                                JsonNode levelValue = statusesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    instanceViewStatusInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode displayStatusValue = statusesValue.get("displayStatus");
                                if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                    String displayStatusInstance;
                                    displayStatusInstance = displayStatusValue.getTextValue();
                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                }
                                
                                JsonNode messageValue = statusesValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    instanceViewStatusInstance.setMessage(messageInstance);
                                }
                                
                                JsonNode timeValue = statusesValue.get("time");
                                if (timeValue != null && timeValue instanceof NullNode == false) {
                                    Calendar timeInstance;
                                    timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        availabilitySetInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        availabilitySetInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        availabilitySetInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        availabilitySetInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            availabilitySetInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to delete the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, availabilitySetName);
            }
         });
    }
    
    /**
    * The operation to delete the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to get the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @return GET Availability Set operation response.
    */
    @Override
    public Future<AvailabilitySetGetResponse> getAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetGetResponse>() { 
            @Override
            public AvailabilitySetGetResponse call() throws Exception {
                return get(resourceGroupName, availabilitySetName);
            }
         });
    }
    
    /**
    * The operation to get the availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return GET Availability Set operation response.
    */
    @Override
    public AvailabilitySetGetResponse get(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            AvailabilitySetGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AvailabilitySetGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    AvailabilitySet availabilitySetInstance = new AvailabilitySet();
                    result.setAvailabilitySet(availabilitySetInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode platformUpdateDomainCountValue = propertiesValue.get("platformUpdateDomainCount");
                        if (platformUpdateDomainCountValue != null && platformUpdateDomainCountValue instanceof NullNode == false) {
                            int platformUpdateDomainCountInstance;
                            platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                        }
                        
                        JsonNode platformFaultDomainCountValue = propertiesValue.get("platformFaultDomainCount");
                        if (platformFaultDomainCountValue != null && platformFaultDomainCountValue instanceof NullNode == false) {
                            int platformFaultDomainCountInstance;
                            platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                        }
                        
                        JsonNode virtualMachinesArray = propertiesValue.get("virtualMachines");
                        if (virtualMachinesArray != null && virtualMachinesArray instanceof NullNode == false) {
                            for (JsonNode virtualMachinesValue : ((ArrayNode) virtualMachinesArray)) {
                                VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                availabilitySetInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                
                                JsonNode idValue = virtualMachinesValue.get("id");
                                if (idValue != null && idValue instanceof NullNode == false) {
                                    String idInstance;
                                    idInstance = idValue.getTextValue();
                                    virtualMachineReferenceInstance.setReferenceUri(idInstance);
                                }
                            }
                        }
                        
                        JsonNode statusesArray = propertiesValue.get("statuses");
                        if (statusesArray != null && statusesArray instanceof NullNode == false) {
                            for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                availabilitySetInstance.getStatuses().add(instanceViewStatusInstance);
                                
                                JsonNode codeValue = statusesValue.get("code");
                                if (codeValue != null && codeValue instanceof NullNode == false) {
                                    String codeInstance;
                                    codeInstance = codeValue.getTextValue();
                                    instanceViewStatusInstance.setCode(codeInstance);
                                }
                                
                                JsonNode levelValue = statusesValue.get("level");
                                if (levelValue != null && levelValue instanceof NullNode == false) {
                                    String levelInstance;
                                    levelInstance = levelValue.getTextValue();
                                    instanceViewStatusInstance.setLevel(levelInstance);
                                }
                                
                                JsonNode displayStatusValue = statusesValue.get("displayStatus");
                                if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                    String displayStatusInstance;
                                    displayStatusInstance = displayStatusValue.getTextValue();
                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                }
                                
                                JsonNode messageValue = statusesValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    instanceViewStatusInstance.setMessage(messageInstance);
                                }
                                
                                JsonNode timeValue = statusesValue.get("time");
                                if (timeValue != null && timeValue instanceof NullNode == false) {
                                    Calendar timeInstance;
                                    timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue2 = responseDoc.get("id");
                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                        String idInstance2;
                        idInstance2 = idValue2.getTextValue();
                        availabilitySetInstance.setId(idInstance2);
                    }
                    
                    JsonNode nameValue = responseDoc.get("name");
                    if (nameValue != null && nameValue instanceof NullNode == false) {
                        String nameInstance;
                        nameInstance = nameValue.getTextValue();
                        availabilitySetInstance.setName(nameInstance);
                    }
                    
                    JsonNode typeValue = responseDoc.get("type");
                    if (typeValue != null && typeValue instanceof NullNode == false) {
                        String typeInstance;
                        typeInstance = typeValue.getTextValue();
                        availabilitySetInstance.setType(typeInstance);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        availabilitySetInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            availabilitySetInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to list the availability sets.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return The List Availability Set operation response.
    */
    @Override
    public Future<AvailabilitySetListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetListResponse>() { 
            @Override
            public AvailabilitySetListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The operation to list the availability sets.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Availability Set operation response.
    */
    @Override
    public AvailabilitySetListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            AvailabilitySetListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AvailabilitySetListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            AvailabilitySet availabilitySetJsonInstance = new AvailabilitySet();
                            result.getAvailabilitySets().add(availabilitySetJsonInstance);
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode platformUpdateDomainCountValue = propertiesValue.get("platformUpdateDomainCount");
                                if (platformUpdateDomainCountValue != null && platformUpdateDomainCountValue instanceof NullNode == false) {
                                    int platformUpdateDomainCountInstance;
                                    platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                                    availabilitySetJsonInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                                }
                                
                                JsonNode platformFaultDomainCountValue = propertiesValue.get("platformFaultDomainCount");
                                if (platformFaultDomainCountValue != null && platformFaultDomainCountValue instanceof NullNode == false) {
                                    int platformFaultDomainCountInstance;
                                    platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                                    availabilitySetJsonInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                                }
                                
                                JsonNode virtualMachinesArray = propertiesValue.get("virtualMachines");
                                if (virtualMachinesArray != null && virtualMachinesArray instanceof NullNode == false) {
                                    for (JsonNode virtualMachinesValue : ((ArrayNode) virtualMachinesArray)) {
                                        VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                        availabilitySetJsonInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                        
                                        JsonNode idValue = virtualMachinesValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            virtualMachineReferenceInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                }
                                
                                JsonNode statusesArray = propertiesValue.get("statuses");
                                if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                    for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        availabilitySetJsonInstance.getStatuses().add(instanceViewStatusInstance);
                                        
                                        JsonNode codeValue = statusesValue.get("code");
                                        if (codeValue != null && codeValue instanceof NullNode == false) {
                                            String codeInstance;
                                            codeInstance = codeValue.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance);
                                        }
                                        
                                        JsonNode levelValue = statusesValue.get("level");
                                        if (levelValue != null && levelValue instanceof NullNode == false) {
                                            String levelInstance;
                                            levelInstance = levelValue.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance);
                                        }
                                        
                                        JsonNode displayStatusValue = statusesValue.get("displayStatus");
                                        if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                            String displayStatusInstance;
                                            displayStatusInstance = displayStatusValue.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                        }
                                        
                                        JsonNode messageValue = statusesValue.get("message");
                                        if (messageValue != null && messageValue instanceof NullNode == false) {
                                            String messageInstance;
                                            messageInstance = messageValue.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance);
                                        }
                                        
                                        JsonNode timeValue = statusesValue.get("time");
                                        if (timeValue != null && timeValue instanceof NullNode == false) {
                                            Calendar timeInstance;
                                            timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                            instanceViewStatusInstance.setTime(timeInstance);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue2 = valueValue.get("id");
                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                String idInstance2;
                                idInstance2 = idValue2.getTextValue();
                                availabilitySetJsonInstance.setId(idInstance2);
                            }
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                availabilitySetJsonInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue = valueValue.get("type");
                            if (typeValue != null && typeValue instanceof NullNode == false) {
                                String typeInstance;
                                typeInstance = typeValue.getTextValue();
                                availabilitySetJsonInstance.setType(typeInstance);
                            }
                            
                            JsonNode locationValue = valueValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                availabilitySetJsonInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    availabilitySetJsonInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists virtual-machine-sizes available to be used for an availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineSizeListResponse> listAvailableSizesAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineSizeListResponse>() { 
            @Override
            public VirtualMachineSizeListResponse call() throws Exception {
                return listAvailableSizes(resourceGroupName, availabilitySetName);
            }
         });
    }
    
    /**
    * Lists virtual-machine-sizes available to be used for an availability set.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param availabilitySetName Required. The name of the availability set.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public VirtualMachineSizeListResponse listAvailableSizes(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter(invocationId, this, "listAvailableSizesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        url = url + "/vmSizes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineSizeListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineSizeListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualMachineSize virtualMachineSizeInstance = new VirtualMachineSize();
                            result.getVirtualMachineSizes().add(virtualMachineSizeInstance);
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineSizeInstance.setName(nameInstance);
                            }
                            
                            JsonNode numberOfCoresValue = valueValue.get("numberOfCores");
                            if (numberOfCoresValue != null && numberOfCoresValue instanceof NullNode == false) {
                                int numberOfCoresInstance;
                                numberOfCoresInstance = numberOfCoresValue.getIntValue();
                                virtualMachineSizeInstance.setNumberOfCores(numberOfCoresInstance);
                            }
                            
                            JsonNode osDiskSizeInMBValue = valueValue.get("osDiskSizeInMB");
                            if (osDiskSizeInMBValue != null && osDiskSizeInMBValue instanceof NullNode == false) {
                                int osDiskSizeInMBInstance;
                                osDiskSizeInMBInstance = osDiskSizeInMBValue.getIntValue();
                                virtualMachineSizeInstance.setOSDiskSizeInMB(osDiskSizeInMBInstance);
                            }
                            
                            JsonNode resourceDiskSizeInMBValue = valueValue.get("resourceDiskSizeInMB");
                            if (resourceDiskSizeInMBValue != null && resourceDiskSizeInMBValue instanceof NullNode == false) {
                                int resourceDiskSizeInMBInstance;
                                resourceDiskSizeInMBInstance = resourceDiskSizeInMBValue.getIntValue();
                                virtualMachineSizeInstance.setResourceDiskSizeInMB(resourceDiskSizeInMBInstance);
                            }
                            
                            JsonNode memoryInMBValue = valueValue.get("memoryInMB");
                            if (memoryInMBValue != null && memoryInMBValue instanceof NullNode == false) {
                                int memoryInMBInstance;
                                memoryInMBInstance = memoryInMBValue.getIntValue();
                                virtualMachineSizeInstance.setMemoryInMB(memoryInMBInstance);
                            }
                            
                            JsonNode maxDataDiskCountValue = valueValue.get("maxDataDiskCount");
                            if (maxDataDiskCountValue != null && maxDataDiskCountValue instanceof NullNode == false) {
                                int maxDataDiskCountInstance;
                                maxDataDiskCountInstance = maxDataDiskCountValue.getIntValue();
                                virtualMachineSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
