/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.windowsazure.core.FilterableService;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Future;

/**
* The Compute Management Client.
*/
public interface ComputeManagementClient extends Closeable, FilterableService<ComputeManagementClient> {
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    String getApiVersion();
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    URI getBaseUri();
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    SubscriptionCloudCredentials getCredentials();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    int getLongRunningOperationInitialTimeout();
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue);
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    int getLongRunningOperationRetryTimeout();
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue);
    /**
    * Operations for managing the availability sets in compute management.
    * @return The AvailabilitySetsOperations value.
    */
    AvailabilitySetOperations getAvailabilitySetsOperations();
    
    /**
    * Operations for listing usage.
    * @return The UsageOperations value.
    */
    UsageOperations getUsageOperations();
    
    /**
    * Operations for managing the virtual machine extension images in compute
    * management.
    * @return The VirtualMachineExtensionImagesOperations value.
    */
    VirtualMachineExtensionImageOperations getVirtualMachineExtensionImagesOperations();
    
    /**
    * Operations for managing the virtual machine extensions in compute
    * management.
    * @return The VirtualMachineExtensionsOperations value.
    */
    VirtualMachineExtensionOperations getVirtualMachineExtensionsOperations();
    
    /**
    * Operations for managing the virtual machine images in compute management.
    * @return The VirtualMachineImagesOperations value.
    */
    VirtualMachineImageOperations getVirtualMachineImagesOperations();
    
    /**
    * Operations for managing the virtual machines in compute management.
    * @return The VirtualMachinesOperations value.
    */
    VirtualMachineOperations getVirtualMachinesOperations();
    
    /**
    * Operations for listing virtual machine sizes available in a region.
    * @return The VirtualMachineSizesOperations value.
    */
    VirtualMachineSizeOperations getVirtualMachineSizesOperations();
    
    /**
    * The Get Delete Operation Status operation returns the status of the
    * specified operation. After calling an asynchronous operation, you can
    * call GetDeleteOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    DeleteOperationResponse getDeleteOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * The Get Delete Operation Status operation returns the status of the
    * specified operation. After calling an asynchronous operation, you can
    * call GetDeleteOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The compute long running operation response.
    */
    Future<DeleteOperationResponse> getDeleteOperationStatusAsync(String operationStatusLink);
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call
    * GetLongRunningOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Compute service response for long-running operations.
    */
    ComputeLongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException;
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call
    * GetLongRunningOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The Compute service response for long-running operations.
    */
    Future<ComputeLongRunningOperationResponse> getLongRunningOperationStatusAsync(String operationStatusLink);
}
