/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageGetParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageListTypesParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageListVersionsParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResourceList;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.Future;

/**
* Operations for managing the virtual machine extension images in compute
* management.
*/
public interface VirtualMachineExtensionImageOperations {
    /**
    * Gets a virtual machine extension image.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The get virtual machine extension image operation response.
    */
    VirtualMachineExtensionImageGetResponse get(VirtualMachineExtensionImageGetParameters parameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * Gets a virtual machine extension image.
    *
    * @param parameters Optional.
    * @return The get virtual machine extension image operation response.
    */
    Future<VirtualMachineExtensionImageGetResponse> getAsync(VirtualMachineExtensionImageGetParameters parameters);
    
    /**
    * Gets a list of virtual machine extension image types.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A list of virtual machine image resource information.
    */
    VirtualMachineImageResourceList listTypes(VirtualMachineExtensionImageListTypesParameters parameters) throws IOException, ServiceException;
    
    /**
    * Gets a list of virtual machine extension image types.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    Future<VirtualMachineImageResourceList> listTypesAsync(VirtualMachineExtensionImageListTypesParameters parameters);
    
    /**
    * Gets a list of virtual machine extension image versions.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A list of virtual machine image resource information.
    */
    VirtualMachineImageResourceList listVersions(VirtualMachineExtensionImageListVersionsParameters parameters) throws IOException, ServiceException;
    
    /**
    * Gets a list of virtual machine extension image versions.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    Future<VirtualMachineImageResourceList> listVersionsAsync(VirtualMachineExtensionImageListVersionsParameters parameters);
}
