/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtension;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionGetResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing the virtual machine extensions in compute management.
*/
public interface VirtualMachineExtensionOperations {
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The compute long running operation response.
    */
    VirtualMachineExtensionCreateOrUpdateResponse beginCreatingOrUpdating(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @return The compute long running operation response.
    */
    Future<VirtualMachineExtensionCreateOrUpdateResponse> beginCreatingOrUpdatingAsync(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters);
    
    /**
    * The operation to delete the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    DeleteOperationResponse beginDeleting(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException;
    
    /**
    * The operation to delete the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The compute long running operation response.
    */
    Future<DeleteOperationResponse> beginDeletingAsync(String resourceGroupName, String vmName, String vmExtensionName);
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The Compute service response for long-running operations.
    */
    ComputeLongRunningOperationResponse createOrUpdate(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @return The Compute service response for long-running operations.
    */
    Future<ComputeLongRunningOperationResponse> createOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters);
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The compute long running operation response.
    */
    DeleteOperationResponse delete(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The compute long running operation response.
    */
    Future<DeleteOperationResponse> deleteAsync(String resourceGroupName, String vmName, String vmExtensionName);
    
    /**
    * The operation to get the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get VM-Extension operation response.
    */
    VirtualMachineExtensionGetResponse get(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * The operation to get the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The Get VM-Extension operation response.
    */
    Future<VirtualMachineExtensionGetResponse> getAsync(String resourceGroupName, String vmName, String vmExtensionName);
    
    /**
    * The operation to get an extension along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get VM-Extension operation response.
    */
    VirtualMachineExtensionGetResponse getWithInstanceView(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException;
    
    /**
    * The operation to get an extension along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The Get VM-Extension operation response.
    */
    Future<VirtualMachineExtensionGetResponse> getWithInstanceViewAsync(String resourceGroupName, String vmName, String vmExtensionName);
}
