/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationStatus;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.VirtualMachineExtension;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionInstanceView;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing the virtual machine extensions in compute management.
*/
public class VirtualMachineExtensionOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, VirtualMachineExtensionOperations {
    /**
    * Initializes a new instance of the VirtualMachineExtensionOperationsImpl
    * class.
    *
    * @param client Reference to the service client.
    */
    VirtualMachineExtensionOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @return The compute long running operation response.
    */
    @Override
    public Future<VirtualMachineExtensionCreateOrUpdateResponse> beginCreatingOrUpdatingAsync(final String resourceGroupName, final String vmName, final VirtualMachineExtension extensionParameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionCreateOrUpdateResponse>() { 
            @Override
            public VirtualMachineExtensionCreateOrUpdateResponse call() throws Exception {
                return beginCreatingOrUpdating(resourceGroupName, vmName, extensionParameters);
            }
         });
    }
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The compute long running operation response.
    */
    @Override
    public VirtualMachineExtensionCreateOrUpdateResponse beginCreatingOrUpdating(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (extensionParameters == null) {
            throw new NullPointerException("extensionParameters");
        }
        if (extensionParameters.getLocation() == null) {
            throw new NullPointerException("extensionParameters.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("extensionParameters", extensionParameters);
            CloudTracing.enter(invocationId, this, "beginCreatingOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        if (extensionParameters.getName() != null) {
            url = url + URLEncoder.encode(extensionParameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualMachineExtensionJsonValue = objectMapper.createObjectNode();
        requestDoc = virtualMachineExtensionJsonValue;
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualMachineExtensionJsonValue).put("properties", propertiesValue);
        
        if (extensionParameters.getPublisher() != null) {
            ((ObjectNode) propertiesValue).put("publisher", extensionParameters.getPublisher());
        }
        
        if (extensionParameters.getExtensionType() != null) {
            ((ObjectNode) propertiesValue).put("type", extensionParameters.getExtensionType());
        }
        
        if (extensionParameters.getTypeHandlerVersion() != null) {
            ((ObjectNode) propertiesValue).put("typeHandlerVersion", extensionParameters.getTypeHandlerVersion());
        }
        
        ((ObjectNode) propertiesValue).put("autoUpgradeMinorVersion", extensionParameters.isAutoUpgradeMinorVersion());
        
        if (extensionParameters.getSettings() != null) {
            ((ObjectNode) propertiesValue).put("settings", objectMapper.readTree(extensionParameters.getSettings()));
        }
        
        if (extensionParameters.getProtectedSettings() != null) {
            ((ObjectNode) propertiesValue).put("protectedSettings", objectMapper.readTree(extensionParameters.getProtectedSettings()));
        }
        
        if (extensionParameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", extensionParameters.getProvisioningState());
        }
        
        if (extensionParameters.getInstanceView() != null) {
            ObjectNode instanceViewValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("instanceView", instanceViewValue);
            
            if (extensionParameters.getInstanceView().getName() != null) {
                ((ObjectNode) instanceViewValue).put("name", extensionParameters.getInstanceView().getName());
            }
            
            if (extensionParameters.getInstanceView().getExtensionType() != null) {
                ((ObjectNode) instanceViewValue).put("type", extensionParameters.getInstanceView().getExtensionType());
            }
            
            if (extensionParameters.getInstanceView().getTypeHandlerVersion() != null) {
                ((ObjectNode) instanceViewValue).put("typeHandlerVersion", extensionParameters.getInstanceView().getTypeHandlerVersion());
            }
            
            if (extensionParameters.getInstanceView().getSubStatuses() != null) {
                if (extensionParameters.getInstanceView().getSubStatuses() instanceof LazyCollection == false || ((LazyCollection) extensionParameters.getInstanceView().getSubStatuses()).isInitialized()) {
                    ArrayNode substatusesArray = objectMapper.createArrayNode();
                    for (InstanceViewStatus substatusesItem : extensionParameters.getInstanceView().getSubStatuses()) {
                        ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                        substatusesArray.add(instanceViewStatusValue);
                        
                        if (substatusesItem.getCode() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("code", substatusesItem.getCode());
                        }
                        
                        if (substatusesItem.getLevel() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("level", substatusesItem.getLevel());
                        }
                        
                        if (substatusesItem.getDisplayStatus() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("displayStatus", substatusesItem.getDisplayStatus());
                        }
                        
                        if (substatusesItem.getMessage() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("message", substatusesItem.getMessage());
                        }
                        
                        if (substatusesItem.getTime() != null) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                            ((ObjectNode) instanceViewStatusValue).put("time", simpleDateFormat.format(substatusesItem.getTime().getTime()));
                        }
                    }
                    ((ObjectNode) instanceViewValue).put("substatuses", substatusesArray);
                }
            }
            
            if (extensionParameters.getInstanceView().getStatuses() != null) {
                ArrayNode statusesArray = objectMapper.createArrayNode();
                for (InstanceViewStatus statusesItem : extensionParameters.getInstanceView().getStatuses()) {
                    ObjectNode instanceViewStatusValue2 = objectMapper.createObjectNode();
                    statusesArray.add(instanceViewStatusValue2);
                    
                    if (statusesItem.getCode() != null) {
                        ((ObjectNode) instanceViewStatusValue2).put("code", statusesItem.getCode());
                    }
                    
                    if (statusesItem.getLevel() != null) {
                        ((ObjectNode) instanceViewStatusValue2).put("level", statusesItem.getLevel());
                    }
                    
                    if (statusesItem.getDisplayStatus() != null) {
                        ((ObjectNode) instanceViewStatusValue2).put("displayStatus", statusesItem.getDisplayStatus());
                    }
                    
                    if (statusesItem.getMessage() != null) {
                        ((ObjectNode) instanceViewStatusValue2).put("message", statusesItem.getMessage());
                    }
                    
                    if (statusesItem.getTime() != null) {
                        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) instanceViewStatusValue2).put("time", simpleDateFormat2.format(statusesItem.getTime().getTime()));
                    }
                }
                ((ObjectNode) instanceViewValue).put("statuses", statusesArray);
            }
        }
        
        if (extensionParameters.getId() != null) {
            ((ObjectNode) virtualMachineExtensionJsonValue).put("id", extensionParameters.getId());
        }
        
        if (extensionParameters.getName() != null) {
            ((ObjectNode) virtualMachineExtensionJsonValue).put("name", extensionParameters.getName());
        }
        
        if (extensionParameters.getType() != null) {
            ((ObjectNode) virtualMachineExtensionJsonValue).put("type", extensionParameters.getType());
        }
        
        ((ObjectNode) virtualMachineExtensionJsonValue).put("location", extensionParameters.getLocation());
        
        if (extensionParameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : extensionParameters.getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) virtualMachineExtensionJsonValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineExtensionCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                        JsonNode publisherValue = propertiesValue2.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode typeValue = propertiesValue2.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        
                        JsonNode typeHandlerVersionValue = propertiesValue2.get("typeHandlerVersion");
                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                            String typeHandlerVersionInstance;
                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        
                        JsonNode autoUpgradeMinorVersionValue = propertiesValue2.get("autoUpgradeMinorVersion");
                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                            boolean autoUpgradeMinorVersionInstance;
                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        
                        JsonNode settingsValue = propertiesValue2.get("settings");
                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                            String settingsInstance;
                            settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        
                        JsonNode protectedSettingsValue = propertiesValue2.get("protectedSettings");
                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                            String protectedSettingsInstance;
                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue2.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue2 = propertiesValue2.get("instanceView");
                        if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode nameValue = instanceViewValue2.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue2 = instanceViewValue2.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            
                            JsonNode typeHandlerVersionValue2 = instanceViewValue2.get("typeHandlerVersion");
                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                String typeHandlerVersionInstance2;
                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            
                            JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                            if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray2)) {
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                        String codeInstance;
                                        codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    
                                    JsonNode levelValue = substatusesValue.get("level");
                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                        String levelInstance;
                                        levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    
                                    JsonNode displayStatusValue = substatusesValue.get("displayStatus");
                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                        String displayStatusInstance;
                                        displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    
                                    JsonNode messageValue = substatusesValue.get("message");
                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                        String messageInstance;
                                        messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    
                                    JsonNode timeValue = substatusesValue.get("time");
                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                        Calendar timeInstance;
                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance);
                                    }
                                }
                            }
                            
                            JsonNode statusesArray2 = instanceViewValue2.get("statuses");
                            if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                for (JsonNode statusesValue : ((ArrayNode) statusesArray2)) {
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                        String codeInstance2;
                                        codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    
                                    JsonNode levelValue2 = statusesValue.get("level");
                                    if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                        String levelInstance2;
                                        levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    
                                    JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                    if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                        String displayStatusInstance2;
                                        displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    
                                    JsonNode messageValue2 = statusesValue.get("message");
                                    if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                        String messageInstance2;
                                        messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    
                                    JsonNode timeValue2 = statusesValue.get("time");
                                    if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                        Calendar timeInstance2;
                                        timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance2);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue3 = responseDoc.get("type");
                    if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                        String typeInstance3;
                        typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey2 = property.getKey();
                            String tagsValue2 = property.getValue().getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to delete the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The compute long running operation response.
    */
    @Override
    public Future<DeleteOperationResponse> beginDeletingAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>() { 
            @Override
            public DeleteOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, vmName, vmExtensionName);
            }
         });
    }
    
    /**
    * The operation to delete the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public DeleteOperationResponse beginDeleting(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeleteOperationResponse result = null;
            // Deserialize Response
            result = new DeleteOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_CONFLICT) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> createOrUpdateAsync(final String resourceGroupName, final String vmName, final VirtualMachineExtension extensionParameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, vmName, extensionParameters);
            }
         });
    }
    
    /**
    * The operation to create or update the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be create or updated.
    * @param extensionParameters Required. Parameters supplied to the Create
    * Virtual Machine Extension operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse createOrUpdate(String resourceGroupName, String vmName, VirtualMachineExtension extensionParameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("extensionParameters", extensionParameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualMachineExtensionCreateOrUpdateResponse response = client2.getVirtualMachineExtensionsOperations().beginCreatingOrUpdatingAsync(resourceGroupName, vmName, extensionParameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The compute long running operation response.
    */
    @Override
    public Future<DeleteOperationResponse> deleteAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>() { 
            @Override
            public DeleteOperationResponse call() throws Exception {
                return delete(resourceGroupName, vmName, vmExtensionName);
            }
         });
    }
    
    /**
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine where the
    * extension should be deleted.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The compute long running operation response.
    */
    @Override
    public DeleteOperationResponse delete(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            DeleteOperationResponse response = client2.getVirtualMachineExtensionsOperations().beginDeletingAsync(resourceGroupName, vmName, vmExtensionName).get();
            if (response.getStatus() == OperationStatus.Succeeded) {
                return response;
            }
            DeleteOperationResponse result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The operation to get the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The Get VM-Extension operation response.
    */
    @Override
    public Future<VirtualMachineExtensionGetResponse> getAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionGetResponse>() { 
            @Override
            public VirtualMachineExtensionGetResponse call() throws Exception {
                return get(resourceGroupName, vmName, vmExtensionName);
            }
         });
    }
    
    /**
    * The operation to get the extension.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get VM-Extension operation response.
    */
    @Override
    public VirtualMachineExtensionGetResponse get(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineExtensionGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode publisherValue = propertiesValue.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode typeValue = propertiesValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        
                        JsonNode typeHandlerVersionValue = propertiesValue.get("typeHandlerVersion");
                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                            String typeHandlerVersionInstance;
                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        
                        JsonNode autoUpgradeMinorVersionValue = propertiesValue.get("autoUpgradeMinorVersion");
                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                            boolean autoUpgradeMinorVersionInstance;
                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        
                        JsonNode settingsValue = propertiesValue.get("settings");
                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                            String settingsInstance;
                            settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        
                        JsonNode protectedSettingsValue = propertiesValue.get("protectedSettings");
                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                            String protectedSettingsInstance;
                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue = propertiesValue.get("instanceView");
                        if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode nameValue = instanceViewValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue2 = instanceViewValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            
                            JsonNode typeHandlerVersionValue2 = instanceViewValue.get("typeHandlerVersion");
                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                String typeHandlerVersionInstance2;
                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            
                            JsonNode substatusesArray = instanceViewValue.get("substatuses");
                            if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                        String codeInstance;
                                        codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    
                                    JsonNode levelValue = substatusesValue.get("level");
                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                        String levelInstance;
                                        levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    
                                    JsonNode displayStatusValue = substatusesValue.get("displayStatus");
                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                        String displayStatusInstance;
                                        displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    
                                    JsonNode messageValue = substatusesValue.get("message");
                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                        String messageInstance;
                                        messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    
                                    JsonNode timeValue = substatusesValue.get("time");
                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                        Calendar timeInstance;
                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance);
                                    }
                                }
                            }
                            
                            JsonNode statusesArray = instanceViewValue.get("statuses");
                            if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                        String codeInstance2;
                                        codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    
                                    JsonNode levelValue2 = statusesValue.get("level");
                                    if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                        String levelInstance2;
                                        levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    
                                    JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                    if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                        String displayStatusInstance2;
                                        displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    
                                    JsonNode messageValue2 = statusesValue.get("message");
                                    if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                        String messageInstance2;
                                        messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    
                                    JsonNode timeValue2 = statusesValue.get("time");
                                    if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                        Calendar timeInstance2;
                                        timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance2);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue3 = responseDoc.get("type");
                    if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                        String typeInstance3;
                        typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to get an extension along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @return The Get VM-Extension operation response.
    */
    @Override
    public Future<VirtualMachineExtensionGetResponse> getWithInstanceViewAsync(final String resourceGroupName, final String vmName, final String vmExtensionName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionGetResponse>() { 
            @Override
            public VirtualMachineExtensionGetResponse call() throws Exception {
                return getWithInstanceView(resourceGroupName, vmName, vmExtensionName);
            }
         });
    }
    
    /**
    * The operation to get an extension along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine containing the
    * extension.
    * @param vmExtensionName Required. The name of the virtual machine
    * extension.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Get VM-Extension operation response.
    */
    @Override
    public VirtualMachineExtensionGetResponse getWithInstanceView(String resourceGroupName, String vmName, String vmExtensionName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (vmExtensionName == null) {
            throw new NullPointerException("vmExtensionName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("vmExtensionName", vmExtensionName);
            CloudTracing.enter(invocationId, this, "getWithInstanceViewAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/extensions/";
        url = url + URLEncoder.encode(vmExtensionName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("$expand=instanceView");
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineExtensionGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString(responseContent);
                if (responseDocContent == null == false && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachineExtension virtualMachineExtensionInstance = new VirtualMachineExtension();
                    result.setVirtualMachineExtension(virtualMachineExtensionInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode publisherValue = propertiesValue.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            virtualMachineExtensionInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode typeValue = propertiesValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            virtualMachineExtensionInstance.setExtensionType(typeInstance);
                        }
                        
                        JsonNode typeHandlerVersionValue = propertiesValue.get("typeHandlerVersion");
                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                            String typeHandlerVersionInstance;
                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                            virtualMachineExtensionInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                        }
                        
                        JsonNode autoUpgradeMinorVersionValue = propertiesValue.get("autoUpgradeMinorVersion");
                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                            boolean autoUpgradeMinorVersionInstance;
                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                            virtualMachineExtensionInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                        }
                        
                        JsonNode settingsValue = propertiesValue.get("settings");
                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                            String settingsInstance;
                            settingsInstance = settingsValue.getTextValue();
                            virtualMachineExtensionInstance.setSettings(settingsInstance);
                        }
                        
                        JsonNode protectedSettingsValue = propertiesValue.get("protectedSettings");
                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                            String protectedSettingsInstance;
                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                            virtualMachineExtensionInstance.setProtectedSettings(protectedSettingsInstance);
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineExtensionInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue = propertiesValue.get("instanceView");
                        if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                            VirtualMachineExtensionInstanceView instanceViewInstance = new VirtualMachineExtensionInstanceView();
                            virtualMachineExtensionInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode nameValue = instanceViewValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                instanceViewInstance.setName(nameInstance);
                            }
                            
                            JsonNode typeValue2 = instanceViewValue.get("type");
                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                String typeInstance2;
                                typeInstance2 = typeValue2.getTextValue();
                                instanceViewInstance.setExtensionType(typeInstance2);
                            }
                            
                            JsonNode typeHandlerVersionValue2 = instanceViewValue.get("typeHandlerVersion");
                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                String typeHandlerVersionInstance2;
                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                instanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                            }
                            
                            JsonNode substatusesArray = instanceViewValue.get("substatuses");
                            if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    instanceViewInstance.getSubStatuses().add(instanceViewStatusInstance);
                                    
                                    JsonNode codeValue = substatusesValue.get("code");
                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                        String codeInstance;
                                        codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    
                                    JsonNode levelValue = substatusesValue.get("level");
                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                        String levelInstance;
                                        levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    
                                    JsonNode displayStatusValue = substatusesValue.get("displayStatus");
                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                        String displayStatusInstance;
                                        displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    
                                    JsonNode messageValue = substatusesValue.get("message");
                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                        String messageInstance;
                                        messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    
                                    JsonNode timeValue = substatusesValue.get("time");
                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                        Calendar timeInstance;
                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance);
                                    }
                                }
                            }
                            
                            JsonNode statusesArray = instanceViewValue.get("statuses");
                            if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                    
                                    JsonNode codeValue2 = statusesValue.get("code");
                                    if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                        String codeInstance2;
                                        codeInstance2 = codeValue2.getTextValue();
                                        instanceViewStatusInstance2.setCode(codeInstance2);
                                    }
                                    
                                    JsonNode levelValue2 = statusesValue.get("level");
                                    if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                        String levelInstance2;
                                        levelInstance2 = levelValue2.getTextValue();
                                        instanceViewStatusInstance2.setLevel(levelInstance2);
                                    }
                                    
                                    JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                    if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                        String displayStatusInstance2;
                                        displayStatusInstance2 = displayStatusValue2.getTextValue();
                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance2);
                                    }
                                    
                                    JsonNode messageValue2 = statusesValue.get("message");
                                    if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                        String messageInstance2;
                                        messageInstance2 = messageValue2.getTextValue();
                                        instanceViewStatusInstance2.setMessage(messageInstance2);
                                    }
                                    
                                    JsonNode timeValue2 = statusesValue.get("time");
                                    if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                        Calendar timeInstance2;
                                        timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance2);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        virtualMachineExtensionInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualMachineExtensionInstance.setName(nameInstance2);
                    }
                    
                    JsonNode typeValue3 = responseDoc.get("type");
                    if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                        String typeInstance3;
                        typeInstance3 = typeValue3.getTextValue();
                        virtualMachineExtensionInstance.setType(typeInstance3);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionInstance.setLocation(locationInstance);
                    }
                    
                    JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry<String, JsonNode> property = itr.next();
                            String tagsKey = property.getKey();
                            String tagsValue = property.getValue().getTextValue();
                            virtualMachineExtensionInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
