/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Gets or sets additional XML formatted information that can be included in the
* Unattend.xml file, which is used by Windows Setup. Contents are defined by
* setting name, component name, and the pass in which the content is a applied.
*/
public class AdditionalUnattendContent {
    private String componentName;
    
    /**
    * Optional. Gets or sets the component name. Currently, the only allowable
    * value is Microsoft-Windows-Shell-Setup.
    * @return The ComponentName value.
    */
    public String getComponentName() {
        return this.componentName;
    }
    
    /**
    * Optional. Gets or sets the component name. Currently, the only allowable
    * value is Microsoft-Windows-Shell-Setup.
    * @param componentNameValue The ComponentName value.
    */
    public void setComponentName(final String componentNameValue) {
        this.componentName = componentNameValue;
    }
    
    private String content;
    
    /**
    * Optional. Gets or sets XML formatted content that is added to the
    * unattend.xml file in the specified pass and component.The XML must be
    * less than 4 KB and must include the root element for the setting or
    * feature that is being inserted.
    * @return The Content value.
    */
    public String getContent() {
        return this.content;
    }
    
    /**
    * Optional. Gets or sets XML formatted content that is added to the
    * unattend.xml file in the specified pass and component.The XML must be
    * less than 4 KB and must include the root element for the setting or
    * feature that is being inserted.
    * @param contentValue The Content value.
    */
    public void setContent(final String contentValue) {
        this.content = contentValue;
    }
    
    private String passName;
    
    /**
    * Optional. Gets or sets the pass name. Currently, the only allowable value
    * is oobeSystem.
    * @return The PassName value.
    */
    public String getPassName() {
        return this.passName;
    }
    
    /**
    * Optional. Gets or sets the pass name. Currently, the only allowable value
    * is oobeSystem.
    * @param passNameValue The PassName value.
    */
    public void setPassName(final String passNameValue) {
        this.passName = passNameValue;
    }
    
    private String settingName;
    
    /**
    * Optional. Gets or sets setting name (e.g. FirstLogonCommands, AutoLogon )
    * @return The SettingName value.
    */
    public String getSettingName() {
        return this.settingName;
    }
    
    /**
    * Optional. Gets or sets setting name (e.g. FirstLogonCommands, AutoLogon )
    * @param settingNameValue The SettingName value.
    */
    public void setSettingName(final String settingNameValue) {
        this.settingName = settingNameValue;
    }
}
